/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.impl.util.FlatMappingTraverser;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface Traverser<T> {
    public T next();

    @Nonnull
    default public <R> Traverser<R> map(@Nonnull Function<? super T, ? extends R> mapFn) {
        return () -> {
            T t;
            while ((t = this.next()) != null) {
                Object r = mapFn.apply((T)t);
                if (r == null) continue;
                return r;
            }
            return null;
        };
    }

    @Nonnull
    default public Traverser<T> filter(@Nonnull Predicate<? super T> filterFn) {
        return () -> {
            T t;
            while ((t = this.next()) != null) {
                if (!filterFn.test((T)t)) continue;
                return t;
            }
            return null;
        };
    }

    @Nonnull
    default public <R> Traverser<R> flatMap(@Nonnull Function<? super T, ? extends Traverser<? extends R>> flatMapFn) {
        return new FlatMappingTraverser(this, flatMapFn);
    }

    @Nonnull
    default public Traverser<T> takeWhile(final @Nonnull Predicate<? super T> pred) {
        return new Traverser<T>(){
            boolean predicateSatisfied = true;

            @Override
            public T next() {
                if (!this.predicateSatisfied) {
                    return null;
                }
                Object t = Traverser.this.next();
                this.predicateSatisfied = t == null || pred.test(t);
                return this.predicateSatisfied ? t : null;
            }
        };
    }

    @Nonnull
    default public Traverser<T> dropWhile(final @Nonnull Predicate<? super T> pred) {
        return new Traverser<T>(){
            boolean predicateSatisfied = true;

            @Override
            public T next() {
                Object t;
                if (!this.predicateSatisfied) {
                    return Traverser.this.next();
                }
                while ((t = Traverser.this.next()) != null) {
                    this.predicateSatisfied = pred.test(t);
                    if (this.predicateSatisfied) continue;
                    return t;
                }
                return null;
            }
        };
    }

    @Nonnull
    default public Traverser<T> append(final @Nonnull T item) {
        return new Traverser<T>(){
            T appendedItem;
            {
                this.appendedItem = item;
            }

            @Override
            public T next() {
                Object t = Traverser.this.next();
                if (t == null) {
                    try {
                        Object t2 = this.appendedItem;
                        return t2;
                    }
                    finally {
                        this.appendedItem = null;
                    }
                }
                return t;
            }
        };
    }

    @Nonnull
    default public Traverser<T> prepend(final @Nonnull T item) {
        return new Traverser<T>(){
            private boolean itemReturned;

            @Override
            public T next() {
                if (this.itemReturned) {
                    return Traverser.this.next();
                }
                this.itemReturned = true;
                return item;
            }
        };
    }

    @Nonnull
    default public Traverser<T> peek(@Nonnull Consumer<? super T> action) {
        return () -> {
            T t = this.next();
            if (t != null) {
                action.accept((T)t);
            }
            return t;
        };
    }

    @Nonnull
    default public Traverser<T> onFirstNull(final @Nonnull Runnable action) {
        return new Traverser<T>(){
            private boolean didRun;

            @Override
            public T next() {
                Object t = Traverser.this.next();
                if (t == null && !this.didRun) {
                    action.run();
                    this.didRun = true;
                }
                return t;
            }
        };
    }
}

