/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.metrics;

import com.hazelcast.config.Config;
import com.hazelcast.internal.diagnostics.Diagnostics;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.renderers.ProbeRenderer;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.config.MetricsConfig;
import com.hazelcast.jet.impl.LiveOperationRegistry;
import com.hazelcast.jet.impl.metrics.MetricsPublisher;
import com.hazelcast.jet.impl.metrics.jmx.JmxPublisher;
import com.hazelcast.jet.impl.metrics.management.ConcurrentArrayRingbuffer;
import com.hazelcast.jet.impl.metrics.management.ManagementCenterPublisher;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.ConfigurableService;
import com.hazelcast.spi.LiveOperations;
import com.hazelcast.spi.LiveOperationsTracker;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class JetMetricsService
implements ManagedService,
ConfigurableService<MetricsConfig>,
LiveOperationsTracker {
    public static final String SERVICE_NAME = "hz:impl:jetMetricsService";
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private final LiveOperationRegistry liveOperationRegistry;
    private final ConcurrentMap<CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>>, Long> pendingReads = new ConcurrentHashMap<CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>>, Long>();
    private ConcurrentArrayRingbuffer<Map.Entry<Long, byte[]>> metricsJournal;
    private MetricsConfig config;
    private volatile ScheduledFuture<?> scheduledFuture;
    private List<MetricsPublisher> publishers;
    private volatile boolean paused;

    public JetMetricsService(NodeEngine nodeEngine) {
        this.nodeEngine = (NodeEngineImpl)nodeEngine;
        this.logger = nodeEngine.getLogger(this.getClass());
        this.liveOperationRegistry = new LiveOperationRegistry();
    }

    public void configure(MetricsConfig config) {
        this.config = config;
    }

    public void init(NodeEngine nodeEngine, Properties properties) {
        this.publishers = this.getPublishers();
        if (this.publishers.isEmpty()) {
            return;
        }
        this.logger.info("Configuring metrics collection, collection interval=" + this.config.getCollectionIntervalSeconds() + " seconds, retention=" + this.config.getRetentionSeconds() + " seconds, publishers=" + this.publishers.stream().map(MetricsPublisher::name).collect(Collectors.joining(", ", "[", "]")));
        PublisherProbeRenderer renderer = new PublisherProbeRenderer();
        this.scheduledFuture = nodeEngine.getExecutionService().scheduleWithRepetition("MetricsPublisher", () -> {
            if (this.paused) {
                this.logger.fine("Metrics not collected, service is paused.");
                return;
            }
            this.nodeEngine.getMetricsRegistry().render(renderer);
            for (MetricsPublisher publisher : this.publishers) {
                try {
                    publisher.whenComplete();
                }
                catch (Exception e) {
                    this.logger.severe("Error completing publication for publisher " + publisher, (Throwable)e);
                }
            }
        }, 1L, (long)this.config.getCollectionIntervalSeconds(), TimeUnit.SECONDS);
    }

    public LiveOperationRegistry getLiveOperationRegistry() {
        return this.liveOperationRegistry;
    }

    public void populate(LiveOperations liveOperations) {
        this.liveOperationRegistry.populate(liveOperations);
    }

    public CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>> readMetrics(long startSequence) {
        if (!this.config.isEnabled()) {
            throw new IllegalArgumentException("Metrics collection is not enabled");
        }
        CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>> future = new CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>>();
        future.whenComplete(ExceptionUtil.withTryCatch(this.logger, (s, e) -> {
            Long cfr_ignored_0 = (Long)this.pendingReads.remove(future);
        }));
        this.pendingReads.put(future, startSequence);
        this.tryCompleteRead(future, startSequence);
        return future;
    }

    private void tryCompleteRead(CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>> future, long sequence) {
        try {
            ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>> slice = this.metricsJournal.copyFrom(sequence);
            if (!slice.isEmpty()) {
                future.complete(slice);
            }
        }
        catch (Exception e) {
            this.logger.severe("Error reading from metrics journal, sequence: " + sequence, (Throwable)e);
            future.completeExceptionally(e);
        }
    }

    public void reset() {
    }

    public void shutdown(boolean terminate) {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
        for (MetricsPublisher publisher : this.publishers) {
            try {
                publisher.shutdown();
            }
            catch (Exception e) {
                this.logger.warning("Error shutting down metrics publisher " + publisher.name(), (Throwable)e);
            }
        }
    }

    public static void applyMetricsConfig(Config hzConfig, MetricsConfig metricsConfig) {
        if (metricsConfig.isEnabled()) {
            hzConfig.setProperty(Diagnostics.METRICS_LEVEL.getName(), ProbeLevel.INFO.name());
            if (metricsConfig.isMetricsForDataStructures()) {
                hzConfig.setProperty(Diagnostics.METRICS_DISTRIBUTED_DATASTRUCTURES.getName(), "true");
            }
        }
    }

    private List<MetricsPublisher> getPublishers() {
        ArrayList<MetricsPublisher> publishers = new ArrayList<MetricsPublisher>();
        if (this.config.isEnabled()) {
            int journalSize = Math.max(1, (int)Math.ceil((double)this.config.getRetentionSeconds() / (double)this.config.getCollectionIntervalSeconds()));
            this.metricsJournal = new ConcurrentArrayRingbuffer(journalSize);
            ManagementCenterPublisher publisher = new ManagementCenterPublisher(this.nodeEngine.getLoggingService(), (blob, ts) -> {
                this.metricsJournal.add(Util.entry(ts, blob));
                this.pendingReads.forEach(this::tryCompleteRead);
            });
            publishers.add(publisher);
        }
        if (this.config.isJmxEnabled()) {
            publishers.add(new JmxPublisher(this.nodeEngine.getHazelcastInstance().getName(), "com.hazelcast"));
        }
        return publishers;
    }

    void pauseCollection() {
        this.paused = true;
    }

    void resumeCollection() {
        this.paused = false;
    }

    private class PublisherProbeRenderer
    implements ProbeRenderer {
        private PublisherProbeRenderer() {
        }

        public void renderLong(String name, long value) {
            for (MetricsPublisher publisher : JetMetricsService.this.publishers) {
                try {
                    publisher.publishLong(name, value);
                }
                catch (Exception e) {
                    this.logError(name, value, publisher, e);
                }
            }
        }

        public void renderDouble(String name, double value) {
            for (MetricsPublisher publisher : JetMetricsService.this.publishers) {
                try {
                    publisher.publishDouble(name, value);
                }
                catch (Exception e) {
                    this.logError(name, value, publisher, e);
                }
            }
        }

        public void renderException(String name, Exception e) {
            JetMetricsService.this.logger.warning("Error when rendering '" + name + '\'', (Throwable)e);
        }

        public void renderNoValue(String name) {
        }

        private void logError(String name, Object value, MetricsPublisher publisher, Exception e) {
            JetMetricsService.this.logger.fine("Error publishing metric to: " + publisher.name() + ", metric=" + name + ", value=" + value, (Throwable)e);
        }
    }
}

