/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution;

import com.hazelcast.jet.core.BroadcastKey;
import com.hazelcast.jet.impl.execution.BroadcastEntry;
import com.hazelcast.jet.impl.execution.DoneItem;
import com.hazelcast.jet.impl.execution.SnapshotBarrier;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;

class ExecutionSerializerHooks {
    ExecutionSerializerHooks() {
    }

    public static final class BroadcastKeyHook
    implements SerializerHook<BroadcastKey> {
        public Class<BroadcastKey> getSerializationType() {
            return BroadcastKey.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<BroadcastKey>(){

                public int getTypeId() {
                    return -320;
                }

                public void destroy() {
                }

                public void write(ObjectDataOutput out, BroadcastKey object) throws IOException {
                    out.writeObject(object.key());
                }

                public BroadcastKey read(ObjectDataInput in) throws IOException {
                    return BroadcastKey.broadcastKey(in.readObject());
                }
            };
        }

        public boolean isOverwritable() {
            return true;
        }
    }

    public static final class BroadcastEntryHook
    implements SerializerHook<BroadcastEntry> {
        public Class<BroadcastEntry> getSerializationType() {
            return BroadcastEntry.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<BroadcastEntry>(){

                public int getTypeId() {
                    return -319;
                }

                public void destroy() {
                }

                public void write(ObjectDataOutput out, BroadcastEntry object) throws IOException {
                    out.writeObject(object.getKey());
                    out.writeObject(object.getValue());
                }

                public BroadcastEntry read(ObjectDataInput in) throws IOException {
                    return new BroadcastEntry<Object, Object>(in.readObject(), in.readObject());
                }
            };
        }

        public boolean isOverwritable() {
            return true;
        }
    }

    public static final class SnapshotBarrierHook
    implements SerializerHook<SnapshotBarrier> {
        public Class<SnapshotBarrier> getSerializationType() {
            return SnapshotBarrier.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<SnapshotBarrier>(){

                public int getTypeId() {
                    return -317;
                }

                public void destroy() {
                }

                public void write(ObjectDataOutput out, SnapshotBarrier object) throws IOException {
                    out.writeLong(object.snapshotId());
                    out.writeBoolean(object.isTerminal());
                }

                public SnapshotBarrier read(ObjectDataInput in) throws IOException {
                    return new SnapshotBarrier(in.readLong(), in.readBoolean());
                }
            };
        }

        public boolean isOverwritable() {
            return true;
        }
    }

    public static final class DoneItemHook
    implements SerializerHook<DoneItem> {
        public Class<DoneItem> getSerializationType() {
            return DoneItem.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<DoneItem>(){

                public int getTypeId() {
                    return -318;
                }

                public void destroy() {
                }

                public void write(ObjectDataOutput out, DoneItem object) {
                }

                public DoneItem read(ObjectDataInput in) {
                    return DoneItem.DONE_ITEM;
                }
            };
        }

        public boolean isOverwritable() {
            return true;
        }
    }
}

