/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.client.impl.ClientEngineImpl;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.JetBuildInfo;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.JobNotFoundException;
import com.hazelcast.jet.impl.JetInstanceImpl;
import com.hazelcast.jet.impl.JobCoordinationService;
import com.hazelcast.jet.impl.JobExecutionService;
import com.hazelcast.jet.impl.JobRecord;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.jet.impl.JobResult;
import com.hazelcast.jet.impl.LiveOperationRegistry;
import com.hazelcast.jet.impl.Networking;
import com.hazelcast.jet.impl.SnapshotRepository;
import com.hazelcast.jet.impl.execution.TaskletExecutionService;
import com.hazelcast.jet.impl.operation.NotifyMemberShutdownOperation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Packet;
import com.hazelcast.spi.ConfigurableService;
import com.hazelcast.spi.LiveOperations;
import com.hazelcast.spi.LiveOperationsTracker;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MemberAttributeServiceEvent;
import com.hazelcast.spi.MembershipAwareService;
import com.hazelcast.spi.MembershipServiceEvent;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.PacketHandler;
import com.hazelcast.spi.properties.GroupProperty;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class JetService
implements ManagedService,
ConfigurableService<JetConfig>,
PacketHandler,
MembershipAwareService,
LiveOperationsTracker {
    public static final String SERVICE_NAME = "hz:impl:jetService";
    public static final int MAX_PARALLEL_ASYNC_OPS = 1000;
    private static final int NOTIFY_MEMBER_SHUTDOWN_DELAY = 5;
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private final LiveOperationRegistry liveOperationRegistry;
    private final AtomicBoolean shutdownInitiated = new AtomicBoolean();
    private final Thread shutdownHookThread;
    private JetConfig config;
    private JetInstance jetInstance;
    private Networking networking;
    private TaskletExecutionService taskletExecutionService;
    private JobRepository jobRepository;
    private JobCoordinationService jobCoordinationService;
    private JobExecutionService jobExecutionService;
    private final AtomicInteger numConcurrentAsyncOps = new AtomicInteger();
    private final Supplier<int[]> sharedPartitionKeys = Util.memoizeConcurrent(this::computeSharedPartitionKeys);

    public JetService(NodeEngine nodeEngine) {
        this.nodeEngine = (NodeEngineImpl)nodeEngine;
        this.logger = nodeEngine.getLogger(this.getClass());
        this.liveOperationRegistry = new LiveOperationRegistry();
        this.shutdownHookThread = this.shutdownHookThread(nodeEngine);
    }

    public void configure(JetConfig config) {
        this.config = config;
    }

    public void init(NodeEngine engine, Properties properties) {
        if (this.config == null) {
            throw new IllegalStateException("JetConfig is not initialized");
        }
        this.jetInstance = new JetInstanceImpl((HazelcastInstanceImpl)engine.getHazelcastInstance(), this.config);
        this.taskletExecutionService = new TaskletExecutionService(this.nodeEngine, this.config.getInstanceConfig().getCooperativeThreadCount());
        SnapshotRepository snapshotRepository = new SnapshotRepository(this.jetInstance);
        this.jobRepository = new JobRepository(this.jetInstance, snapshotRepository);
        this.jobExecutionService = new JobExecutionService(this.nodeEngine, this.taskletExecutionService, this.jobRepository);
        this.jobCoordinationService = new JobCoordinationService(this.nodeEngine, this, this.config, this.jobRepository, snapshotRepository);
        this.networking = new Networking(engine, this.jobExecutionService, this.config.getInstanceConfig().getFlowControlPeriodMs());
        ClientEngineImpl clientEngine = (ClientEngineImpl)engine.getService("hz:core:clientEngine");
        ExceptionUtil.registerJetExceptions(clientEngine.getClientExceptionFactory());
        this.jobCoordinationService.init();
        if (Boolean.parseBoolean(properties.getProperty(GroupProperty.SHUTDOWNHOOK_ENABLED.getName()))) {
            this.logger.finest("Adding Jet shutdown hook");
            Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
        }
        JetBuildInfo jetBuildInfo = BuildInfoProvider.getBuildInfo().getJetBuildInfo();
        this.logger.info(String.format("Starting Jet %s (%s - %s)", jetBuildInfo.getVersion(), jetBuildInfo.getBuild(), jetBuildInfo.getRevision()));
        this.logger.info("Setting number of cooperative threads and default parallelism to " + this.config.getInstanceConfig().getCooperativeThreadCount());
        this.logger.info("\n\to   o   o   o---o o---o o     o---o   o   o---o o-o-o        o o---o o-o-o\n\t|   |  / \\     /  |     |     |      / \\  |       |          | |       |  \n\to---o o---o   o   o-o   |     o     o---o o---o   |          | o-o     |  \n\t|   | |   |  /    |     |     |     |   |     |   |      \\   | |       |  \n\to   o o   o o---o o---o o---o o---o o   o o---o   o       o--o o---o   o   ");
        this.logger.info("Copyright (c) 2008-2018, Hazelcast, Inc. All Rights Reserved.");
    }

    void shutDownJobs() {
        if (!this.shutdownInitiated.compareAndSet(false, true)) {
            this.logger.info("Shutdown requested, but already shut down or being shut down");
            return;
        }
        this.jobCoordinationService.shutdown();
        this.jobExecutionService.shutdown(true);
        this.taskletExecutionService.shutdown(true);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.notifyMasterWeAreShuttingDown(future);
        this.taskletExecutionService.awaitWorkerTermination();
        future.join();
    }

    private void notifyMasterWeAreShuttingDown(final CompletableFuture<Void> result) {
        NotifyMemberShutdownOperation op = new NotifyMemberShutdownOperation();
        this.nodeEngine.getOperationService().invokeOnTarget(SERVICE_NAME, (Operation)op, this.nodeEngine.getClusterService().getMasterAddress()).andThen((ExecutionCallback)new ExecutionCallback<Object>(){

            public void onResponse(Object response) {
                result.complete(null);
            }

            public void onFailure(Throwable t) {
                JetService.this.logger.warning("Failed to notify master member that this member is shutting down, will retry in 5 seconds", t);
                JetService.this.nodeEngine.getExecutionService().schedule(() -> JetService.this.notifyMasterWeAreShuttingDown(result), 5L, TimeUnit.SECONDS);
            }
        });
    }

    public void shutdown(boolean forceful) {
        if (!Thread.currentThread().equals(this.shutdownHookThread)) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
        }
        this.jobCoordinationService.shutdown();
        this.jobExecutionService.shutdown(false);
        this.taskletExecutionService.shutdown(false);
        this.taskletExecutionService.awaitWorkerTermination();
        this.networking.shutdown();
    }

    public void reset() {
        this.jobExecutionService.reset();
        this.jobCoordinationService.reset();
    }

    public JetInstance getJetInstance() {
        return this.jetInstance;
    }

    public LiveOperationRegistry getLiveOperationRegistry() {
        return this.liveOperationRegistry;
    }

    public JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public JobCoordinationService getJobCoordinationService() {
        return this.jobCoordinationService;
    }

    public JobExecutionService getJobExecutionService() {
        return this.jobExecutionService;
    }

    public JobConfig getJobConfig(long jobId) {
        JobRecord jobRecord = this.jobRepository.getJobRecord(jobId);
        if (jobRecord != null) {
            return jobRecord.getConfig();
        }
        JobResult jobResult = this.jobRepository.getJobResult(jobId);
        if (jobResult != null) {
            return jobResult.getJobConfig();
        }
        throw new JobNotFoundException(jobId);
    }

    public ClassLoader getClassLoader(long jobId) {
        return this.getJobExecutionService().getClassLoader(this.getJobConfig(jobId), jobId);
    }

    public void handle(Packet packet) throws IOException {
        this.networking.handle(packet);
    }

    public void memberRemoved(MembershipServiceEvent event) {
        this.jobExecutionService.onMemberLeave(event.getMember().getAddress());
        this.jobCoordinationService.onMemberLeave(event.getMember().getUuid());
    }

    public void memberAdded(MembershipServiceEvent event) {
        this.jobCoordinationService.onMemberAdded(event.getMember());
    }

    public void memberAttributeChanged(MemberAttributeServiceEvent event) {
    }

    public AtomicInteger numConcurrentAsyncOps() {
        return this.numConcurrentAsyncOps;
    }

    public void populate(LiveOperations liveOperations) {
        this.liveOperationRegistry.populate(liveOperations);
    }

    public int[] getSharedPartitionKeys() {
        return this.sharedPartitionKeys.get();
    }

    private int[] computeSharedPartitionKeys() {
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        int[] keys = new int[partitionService.getPartitionCount()];
        int remainingCount = partitionService.getPartitionCount();
        int i = 1;
        while (remainingCount > 0) {
            int partitionId = partitionService.getPartitionId((Object)i);
            if (keys[partitionId] == 0) {
                keys[partitionId] = i;
                --remainingCount;
            }
            ++i;
        }
        return keys;
    }

    private Thread shutdownHookThread(NodeEngine nodeEngine) {
        return new Thread(() -> {
            String policy = nodeEngine.getProperties().getString(GroupProperty.SHUTDOWNHOOK_POLICY);
            if (policy.equals("TERMINATE")) {
                this.jetInstance.getHazelcastInstance().getLifecycleService().terminate();
            } else {
                this.jetInstance.shutdown();
            }
        }, "jet.ShutdownThread");
    }
}

