/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.datamodel;

import com.hazelcast.jet.datamodel.ItemsByTag;
import com.hazelcast.jet.datamodel.Tag;
import com.hazelcast.jet.datamodel.TimestampedEntry;
import com.hazelcast.jet.datamodel.TimestampedItem;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.datamodel.Tuple3;
import com.hazelcast.jet.datamodel.Tuple4;
import com.hazelcast.jet.datamodel.Tuple5;
import com.hazelcast.jet.datamodel.WindowResult;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

class DataModelSerializerHooks {
    DataModelSerializerHooks() {
    }

    private static class ItemsByTagSerializer
    implements StreamSerializer<ItemsByTag> {
        private ItemsByTagSerializer() {
        }

        public void write(ObjectDataOutput out, ItemsByTag ibt) throws IOException {
            Set<Map.Entry<Tag<?>, Object>> entries = ibt.entrySet();
            out.writeInt(entries.size());
            for (Map.Entry<Tag<?>, Object> e : entries) {
                out.writeObject(e.getKey());
                Object val = e.getValue();
                out.writeObject(val != ItemsByTag.NONE ? val : null);
            }
        }

        public ItemsByTag read(ObjectDataInput in) throws IOException {
            int size = in.readInt();
            ItemsByTag ibt = new ItemsByTag();
            for (int i = 0; i < size; ++i) {
                ibt.put((Tag)in.readObject(), in.readObject());
            }
            return ibt;
        }

        public int getTypeId() {
            return -315;
        }

        public void destroy() {
        }
    }

    public static final class ItemsByTagHook
    implements SerializerHook<ItemsByTag> {
        public Class<ItemsByTag> getSerializationType() {
            return ItemsByTag.class;
        }

        public Serializer createSerializer() {
            return new ItemsByTagSerializer();
        }

        public boolean isOverwritable() {
            return false;
        }
    }

    public static final class TagHook
    implements SerializerHook<Tag> {
        public Class<Tag> getSerializationType() {
            return Tag.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<Tag>(){

                public void write(ObjectDataOutput out, Tag tag) throws IOException {
                    out.writeInt(tag.index());
                }

                public Tag read(ObjectDataInput in) throws IOException {
                    return Tag.tag(in.readInt());
                }

                public int getTypeId() {
                    return -314;
                }

                public void destroy() {
                }
            };
        }

        public boolean isOverwritable() {
            return false;
        }
    }

    public static final class Tuple5Hook
    implements SerializerHook<Tuple5> {
        public Class<Tuple5> getSerializationType() {
            return Tuple5.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<Tuple5>(){

                public void write(ObjectDataOutput out, Tuple5 t) throws IOException {
                    out.writeObject(t.f0());
                    out.writeObject(t.f1());
                    out.writeObject(t.f2());
                    out.writeObject(t.f3());
                    out.writeObject(t.f4());
                }

                public Tuple5 read(ObjectDataInput in) throws IOException {
                    return Tuple5.tuple5(in.readObject(), in.readObject(), in.readObject(), in.readObject(), in.readObject());
                }

                public int getTypeId() {
                    return -313;
                }

                public void destroy() {
                }
            };
        }

        public boolean isOverwritable() {
            return false;
        }
    }

    public static final class Tuple4Hook
    implements SerializerHook<Tuple4> {
        public Class<Tuple4> getSerializationType() {
            return Tuple4.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<Tuple4>(){

                public void write(ObjectDataOutput out, Tuple4 t) throws IOException {
                    out.writeObject(t.f0());
                    out.writeObject(t.f1());
                    out.writeObject(t.f2());
                    out.writeObject(t.f3());
                }

                public Tuple4 read(ObjectDataInput in) throws IOException {
                    return Tuple4.tuple4(in.readObject(), in.readObject(), in.readObject(), in.readObject());
                }

                public int getTypeId() {
                    return -312;
                }

                public void destroy() {
                }
            };
        }

        public boolean isOverwritable() {
            return false;
        }
    }

    public static final class Tuple3Hook
    implements SerializerHook<Tuple3> {
        public Class<Tuple3> getSerializationType() {
            return Tuple3.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<Tuple3>(){

                public void write(ObjectDataOutput out, Tuple3 t) throws IOException {
                    out.writeObject(t.f0());
                    out.writeObject(t.f1());
                    out.writeObject(t.f2());
                }

                public Tuple3 read(ObjectDataInput in) throws IOException {
                    return Tuple3.tuple3(in.readObject(), in.readObject(), in.readObject());
                }

                public int getTypeId() {
                    return -311;
                }

                public void destroy() {
                }
            };
        }

        public boolean isOverwritable() {
            return false;
        }
    }

    public static final class Tuple2Hook
    implements SerializerHook<Tuple2> {
        public Class<Tuple2> getSerializationType() {
            return Tuple2.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<Tuple2>(){

                public void write(ObjectDataOutput out, Tuple2 t) throws IOException {
                    out.writeObject(t.f0());
                    out.writeObject(t.f1());
                }

                public Tuple2 read(ObjectDataInput in) throws IOException {
                    return Tuple2.tuple2(in.readObject(), in.readObject());
                }

                public int getTypeId() {
                    return -310;
                }

                public void destroy() {
                }
            };
        }

        public boolean isOverwritable() {
            return false;
        }
    }

    public static final class WindowResultHook
    implements SerializerHook<WindowResult> {
        public Class<WindowResult> getSerializationType() {
            return WindowResult.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<WindowResult>(){

                public void write(ObjectDataOutput out, WindowResult object) throws IOException {
                    out.writeObject(object.getKey());
                    out.writeLong(object.getStart());
                    out.writeLong(object.getEnd());
                    out.writeObject(object.getValue());
                }

                public WindowResult read(ObjectDataInput in) throws IOException {
                    Object key = in.readObject();
                    long start = in.readLong();
                    long end = in.readLong();
                    Object result = in.readObject();
                    return new WindowResult<Object, Object>(start, end, key, result);
                }

                public int getTypeId() {
                    return -321;
                }

                public void destroy() {
                }
            };
        }

        public boolean isOverwritable() {
            return false;
        }
    }

    public static final class TimestampedEntryHook
    implements SerializerHook<TimestampedEntry> {
        public Class<TimestampedEntry> getSerializationType() {
            return TimestampedEntry.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<TimestampedEntry>(){

                public void write(ObjectDataOutput out, TimestampedEntry object) throws IOException {
                    out.writeLong(object.getTimestamp());
                    out.writeObject(object.getKey());
                    out.writeObject(object.getValue());
                }

                public TimestampedEntry read(ObjectDataInput in) throws IOException {
                    long timestamp = in.readLong();
                    Object key = in.readObject();
                    Object value = in.readObject();
                    return new TimestampedEntry<Object, Object>(timestamp, key, value);
                }

                public int getTypeId() {
                    return -303;
                }

                public void destroy() {
                }
            };
        }

        public boolean isOverwritable() {
            return false;
        }
    }

    public static final class TimestampedItemHook
    implements SerializerHook<TimestampedItem> {
        public Class<TimestampedItem> getSerializationType() {
            return TimestampedItem.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<TimestampedItem>(){

                public int getTypeId() {
                    return -325;
                }

                public void destroy() {
                }

                public void write(ObjectDataOutput out, TimestampedItem timestampedItem) throws IOException {
                    out.writeLong(timestampedItem.timestamp());
                    out.writeObject(timestampedItem.item());
                }

                public TimestampedItem read(ObjectDataInput in) throws IOException {
                    long timestamp = in.readLong();
                    Object item = in.readObject();
                    return new TimestampedItem<Object>(timestamp, item);
                }
            };
        }

        public boolean isOverwritable() {
            return false;
        }
    }
}

