/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core.test;

import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import javax.annotation.Nonnull;

public class TestProcessorMetaSupplierContext
implements ProcessorMetaSupplier.Context {
    protected ILogger logger;
    private JetInstance jetInstance;
    private long jobId = 1L;
    private long executionId = 1L;
    private JobConfig jobConfig = new JobConfig();
    private int totalParallelism = 1;
    private int localParallelism = 1;
    private String vertexName = "testVertex";

    @Override
    @Nonnull
    public JetInstance jetInstance() {
        return this.jetInstance;
    }

    @Nonnull
    public TestProcessorMetaSupplierContext setJetInstance(@Nonnull JetInstance jetInstance) {
        this.jetInstance = jetInstance;
        return this;
    }

    @Override
    public long jobId() {
        return this.jobId;
    }

    public TestProcessorMetaSupplierContext setJobId(long jobId) {
        this.jobId = jobId;
        return this;
    }

    @Override
    public long executionId() {
        return this.executionId;
    }

    public TestProcessorMetaSupplierContext setExecutionId(long executionId) {
        this.executionId = executionId;
        return this;
    }

    @Override
    @Nonnull
    public JobConfig jobConfig() {
        return this.jobConfig;
    }

    public TestProcessorMetaSupplierContext setJobConfig(@Nonnull JobConfig jobConfig) {
        this.jobConfig = jobConfig;
        return this;
    }

    @Override
    public int totalParallelism() {
        return this.totalParallelism;
    }

    @Nonnull
    public TestProcessorMetaSupplierContext setTotalParallelism(int totalParallelism) {
        this.totalParallelism = totalParallelism;
        return this;
    }

    @Override
    public int localParallelism() {
        assert (this.totalParallelism % this.localParallelism == 0) : "totalParallelism=" + this.totalParallelism + " not divisible with localParallelism=" + this.localParallelism;
        return this.localParallelism;
    }

    @Nonnull
    public TestProcessorMetaSupplierContext setLocalParallelism(int localParallelism) {
        this.localParallelism = localParallelism;
        return this;
    }

    @Override
    @Nonnull
    public ILogger logger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger((String)this.loggerName());
        }
        return this.logger;
    }

    public TestProcessorMetaSupplierContext setLogger(@Nonnull ILogger logger) {
        this.logger = logger;
        return this;
    }

    @Override
    public int memberCount() {
        return this.totalParallelism() / this.localParallelism();
    }

    @Override
    @Nonnull
    public String vertexName() {
        return this.vertexName;
    }

    @Nonnull
    public TestProcessorMetaSupplierContext setVertexName(@Nonnull String vertexName) {
        this.vertexName = vertexName;
        return this;
    }

    protected String loggerName() {
        return this.vertexName() + "#PMS";
    }
}

