/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.jet.core.SlidingWindowPolicy;
import com.hazelcast.util.Preconditions;
import java.io.Serializable;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface WatermarkEmissionPolicy
extends Serializable {
    public static final WatermarkEmissionPolicy NULL_EMIT_POLICY = (currentWm, lastEmittedWm) -> {
        throw new UnsupportedOperationException("Tried to use the NULL watermark emission policy");
    };

    public long throttleWm(long var1, long var3);

    @Nonnull
    public static WatermarkEmissionPolicy noThrottling() {
        return (currentWm, lastEmittedWm) -> currentWm;
    }

    @Nonnull
    public static WatermarkEmissionPolicy noWatermarks() {
        return (currentWm, lastEmittedWm) -> lastEmittedWm;
    }

    @Nonnull
    public static WatermarkEmissionPolicy emitByMinStep(long minStep) {
        Preconditions.checkPositive((long)minStep, (String)"minStep should be > 0");
        return (currentWm, lastEmittedWm) -> lastEmittedWm + minStep <= currentWm ? currentWm : lastEmittedWm;
    }

    @Nonnull
    public static WatermarkEmissionPolicy emitByFrame(SlidingWindowPolicy wDef) {
        return (currentWm, lastEmittedWm) -> Math.max(wDef.floorFrameTs(currentWm), lastEmittedWm);
    }
}

