/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.reducers;

import com.hazelcast.jet.IListJet;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.core.processor.SinkProcessors;
import com.hazelcast.jet.stream.DistributedCollector;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.pipeline.Pipe;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;

public class IListReducer<T>
implements DistributedCollector.Reducer<T, IListJet<T>> {
    private final String listName;

    public IListReducer(String listName) {
        this.listName = listName;
    }

    @Override
    public IListJet<T> reduce(StreamContext context, Pipe<? extends T> upstream) {
        IListJet target = context.getJetInstance().getList(this.listName);
        DAG dag = new DAG();
        Vertex vertex = upstream.buildDAG(dag);
        Vertex writer = dag.newVertex("write-list-" + this.listName, SinkProcessors.writeListP(this.listName)).localParallelism(1);
        dag.edge(Edge.between(vertex, writer));
        StreamUtil.executeJob(context, dag);
        return target;
    }
}

