/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.pipeline;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedPredicate;
import com.hazelcast.jet.stream.DistributedStream;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.pipeline.AbstractIntermediatePipe;
import com.hazelcast.jet.stream.impl.pipeline.Pipe;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import com.hazelcast.jet.stream.impl.processor.TransformP;
import java.util.stream.Stream;

class TransformPipe<E_IN, E_OUT>
extends AbstractIntermediatePipe<E_IN, E_OUT> {
    private final DistributedFunction<Traverser<E_IN>, Traverser<E_OUT>> transformer;

    TransformPipe(StreamContext context, Pipe<E_IN> upstream, DistributedFunction<Traverser<E_IN>, Traverser<E_OUT>> transformer) {
        super(context, upstream.isOrdered(), upstream);
        this.transformer = transformer;
    }

    @Override
    public Vertex buildDAG(DAG dag) {
        Vertex previous = this.upstream.buildDAG(dag);
        DistributedFunction transformer = this.transformer;
        Vertex transform = dag.newVertex(StreamUtil.uniqueVertexName("transform"), () -> new TransformP(transformer));
        if (this.upstream.isOrdered()) {
            transform.localParallelism(1);
        }
        dag.edge(Edge.between(previous, transform));
        return transform;
    }

    @Override
    public DistributedStream<E_OUT> filter(DistributedPredicate<? super E_OUT> predicate) {
        DistributedFunction transformer = this.transformer;
        return new TransformPipe<E_IN, E_OUT>(this.context, this.upstream, t -> ((Traverser)transformer.apply((Traverser)t)).filter(predicate));
    }

    @Override
    public <R> DistributedStream<R> map(DistributedFunction<? super E_OUT, ? extends R> mapper) {
        DistributedFunction transformer = this.transformer;
        return new TransformPipe<E_IN, E_OUT>(this.context, this.upstream, t -> ((Traverser)transformer.apply((Traverser)t)).map(mapper));
    }

    @Override
    public <R> DistributedStream<R> flatMap(DistributedFunction<? super E_OUT, ? extends Stream<? extends R>> mapper) {
        DistributedFunction transformer = this.transformer;
        return new TransformPipe<E_IN, E_OUT>(this.context, this.upstream, t -> ((Traverser)transformer.apply((Traverser)t)).flatMap((? super T item) -> Traversers.traverseStream((Stream)mapper.apply((Object)item))));
    }
}

