/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.pipeline;

import com.hazelcast.core.IList;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.stream.DistributedCollector;
import com.hazelcast.jet.stream.DistributedCollectors;
import com.hazelcast.jet.stream.DistributedDoubleStream;
import com.hazelcast.jet.stream.DistributedIntStream;
import com.hazelcast.jet.stream.DistributedLongStream;
import com.hazelcast.jet.stream.DistributedStream;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.pipeline.DistinctPipe;
import com.hazelcast.jet.stream.impl.pipeline.DoublePipeline;
import com.hazelcast.jet.stream.impl.pipeline.IntPipeline;
import com.hazelcast.jet.stream.impl.pipeline.LimitPipe;
import com.hazelcast.jet.stream.impl.pipeline.LongPipe;
import com.hazelcast.jet.stream.impl.pipeline.PeekPipe;
import com.hazelcast.jet.stream.impl.pipeline.Pipe;
import com.hazelcast.jet.stream.impl.pipeline.SkipPipe;
import com.hazelcast.jet.stream.impl.pipeline.SortPipe;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import com.hazelcast.jet.stream.impl.pipeline.TransformPipe;
import com.hazelcast.jet.stream.impl.pipeline.UnorderedPipe;
import com.hazelcast.jet.stream.impl.reducers.AnyMatchReducer;
import com.hazelcast.jet.stream.impl.reducers.BiConsumerCombinerReducer;
import com.hazelcast.jet.stream.impl.reducers.Reducers;
import com.hazelcast.util.Preconditions;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

abstract class AbstractPipe<E_OUT>
implements Pipe<E_OUT> {
    protected final StreamContext context;
    private final boolean isOrdered;

    AbstractPipe(StreamContext context) {
        this(context, false);
    }

    AbstractPipe(StreamContext context, boolean isOrdered) {
        this.context = context;
        this.isOrdered = isOrdered;
    }

    @Override
    public DistributedStream<E_OUT> filter(Predicate<? super E_OUT> predicate) {
        Util.checkSerializable(predicate, "predicate");
        return new TransformPipe(this.context, this, t -> t.filter(predicate));
    }

    @Override
    public <R> DistributedStream<R> map(Function<? super E_OUT, ? extends R> mapper) {
        Util.checkSerializable(mapper, "mapper");
        return new TransformPipe(this.context, this, t -> t.map(mapper));
    }

    @Override
    public DistributedIntStream mapToInt(ToIntFunction<? super E_OUT> mapper) {
        Util.checkSerializable(mapper, "mapper");
        Pipe map = (Pipe)this.map(mapper::applyAsInt);
        return new IntPipeline(this.context, map);
    }

    @Override
    public DistributedLongStream mapToLong(ToLongFunction<? super E_OUT> mapper) {
        Util.checkSerializable(mapper, "mapper");
        Pipe map = (Pipe)this.map(mapper::applyAsLong);
        return new LongPipe(this.context, map);
    }

    @Override
    public DistributedDoubleStream mapToDouble(ToDoubleFunction<? super E_OUT> mapper) {
        Util.checkSerializable(mapper, "mapper");
        Pipe map = (Pipe)this.map(mapper::applyAsDouble);
        return new DoublePipeline(this.context, map);
    }

    @Override
    public <R> DistributedStream<R> flatMap(Function<? super E_OUT, ? extends Stream<? extends R>> mapper) {
        Util.checkSerializable(mapper, "mapper");
        return new TransformPipe(this.context, this, t -> t.flatMap((? super T item) -> Traversers.traverseStream((Stream)mapper.apply((Object)item))));
    }

    @Override
    public DistributedIntStream flatMapToInt(Function<? super E_OUT, ? extends IntStream> mapper) {
        Util.checkSerializable(mapper, "mapper");
        Pipe pipeline = (Pipe)this.flatMap(m -> ((IntStream)mapper.apply((Object)m)).boxed());
        return new IntPipeline(this.context, pipeline);
    }

    @Override
    public DistributedLongStream flatMapToLong(Function<? super E_OUT, ? extends LongStream> mapper) {
        Util.checkSerializable(mapper, "mapper");
        Pipe pipeline = (Pipe)this.flatMap(m -> ((LongStream)mapper.apply((Object)m)).boxed());
        return new LongPipe(this.context, pipeline);
    }

    @Override
    public DistributedDoubleStream flatMapToDouble(Function<? super E_OUT, ? extends DoubleStream> mapper) {
        Util.checkSerializable(mapper, "mapper");
        Pipe pipeline = (Pipe)this.flatMap(m -> ((DoubleStream)mapper.apply((Object)m)).boxed());
        return new DoublePipeline(this.context, pipeline);
    }

    @Override
    public DistributedStream<E_OUT> distinct() {
        return new DistinctPipe(this.context, this);
    }

    @Override
    public DistributedStream<E_OUT> sorted() {
        return this.sorted(null);
    }

    @Override
    public final DistributedStream<E_OUT> sorted(Comparator<? super E_OUT> comparator) {
        Util.checkSerializable(comparator, "comparator");
        return new SortPipe<E_OUT>(this, this.context, comparator);
    }

    @Override
    public DistributedStream<E_OUT> peek(Consumer<? super E_OUT> action) {
        Util.checkSerializable(action, "action");
        return new PeekPipe<E_OUT>(this.context, this, action);
    }

    @Override
    public DistributedStream<E_OUT> limit(long maxSize) {
        return new LimitPipe(this.context, this, maxSize);
    }

    @Override
    public DistributedStream<E_OUT> skip(long n) {
        return new SkipPipe(this.context, this, n);
    }

    @Override
    public void forEach(Consumer<? super E_OUT> action) {
        IList list = this.collect(DistributedCollectors.toIList(StreamUtil.uniqueListName()));
        list.forEach(action::accept);
        list.destroy();
    }

    @Override
    public void forEachOrdered(Consumer<? super E_OUT> action) {
        this.forEach(action);
    }

    @Override
    public Object[] toArray() {
        IList list = this.collect(DistributedCollectors.toIList(StreamUtil.uniqueListName()));
        Object[] array = list.toArray();
        list.destroy();
        return array;
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        IList list = this.collect(DistributedCollectors.toIList(StreamUtil.uniqueListName()));
        Object[] array = generator.apply(list.size());
        array = list.toArray(array);
        list.destroy();
        return array;
    }

    @Override
    public E_OUT reduce(E_OUT identity, BinaryOperator<E_OUT> accumulator) {
        Util.checkSerializable(identity, "identity");
        Util.checkSerializable(accumulator, "accumulator");
        return (E_OUT)this.collect((DistributedCollector.Reducer)new Reducers.BinaryAccumulateWithIdentity<E_OUT>(identity, accumulator));
    }

    @Override
    public Optional<E_OUT> reduce(BinaryOperator<E_OUT> accumulator) {
        Util.checkSerializable(accumulator, "accumulator");
        return (Optional)this.collect((DistributedCollector.Reducer)new Reducers.BinaryAccumulate<E_OUT>(accumulator));
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super E_OUT, U> accumulator, BinaryOperator<U> combiner) {
        Util.checkSerializable(identity, "identity");
        Util.checkSerializable(accumulator, "accumulator");
        Util.checkSerializable(combiner, "combiner");
        return this.collect((DistributedCollector.Reducer)new Reducers.AccumulateCombineWithIdentity<E_OUT, U>(identity, accumulator, combiner));
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super E_OUT> accumulator, BiConsumer<R, R> combiner) {
        Util.checkSerializable(supplier, "supplier");
        Util.checkSerializable(accumulator, "accumulator");
        Util.checkSerializable(combiner, "combiner");
        return this.collect((DistributedCollector.Reducer<? super E_OUT, R>)new BiConsumerCombinerReducer<E_OUT, R>(supplier, accumulator, combiner));
    }

    @Override
    public <R, A> R collect(Collector<? super E_OUT, A, R> collector) {
        Preconditions.checkTrue((boolean)(collector instanceof DistributedCollector), (String)"collector must of type DistributedCollector");
        return this.collect((DistributedCollector)collector);
    }

    @Override
    public <R> R collect(DistributedCollector.Reducer<? super E_OUT, R> reducer) {
        return reducer.reduce(this.context, this);
    }

    @Override
    public Optional<E_OUT> min(Comparator<? super E_OUT> comparator) {
        Util.checkSerializable(comparator, "comparator");
        return this.reduce((left, right) -> comparator.compare((Object)left, (Object)right) < 0 ? left : right);
    }

    @Override
    public Optional<E_OUT> max(Comparator<? super E_OUT> comparator) {
        Util.checkSerializable(comparator, "comparator");
        return this.reduce((left, right) -> comparator.compare((Object)left, (Object)right) > 0 ? left : right);
    }

    @Override
    public long count() {
        return this.reduce(Long.valueOf(0L), (i, m) -> i + 1L, (a, b) -> a + b);
    }

    @Override
    public boolean anyMatch(Predicate<? super E_OUT> predicate) {
        Util.checkSerializable(predicate, "predicate");
        return (Boolean)this.collect((DistributedCollector.Reducer)new AnyMatchReducer<E_OUT>(predicate));
    }

    @Override
    public boolean allMatch(Predicate<? super E_OUT> predicate) {
        return !this.anyMatch(t -> !predicate.test((Object)t));
    }

    @Override
    public boolean noneMatch(Predicate<? super E_OUT> predicate) {
        return !this.anyMatch(predicate);
    }

    @Override
    public Optional<E_OUT> findFirst() {
        IList first = this.limit(1L).collect(DistributedCollectors.toIList(StreamUtil.uniqueListName()));
        Optional value = first.size() == 0 ? Optional.empty() : Optional.of(first.get(0));
        first.destroy();
        return value;
    }

    @Override
    public Optional<E_OUT> findAny() {
        return this.findFirst();
    }

    @Override
    public Iterator<E_OUT> iterator() {
        IList list = this.collect(DistributedCollectors.toIList(StreamUtil.uniqueListName()));
        Iterator iterator = list.iterator();
        list.destroy();
        return iterator;
    }

    @Override
    public boolean isParallel() {
        return true;
    }

    @Override
    public DistributedStream<E_OUT> sequential() {
        throw new UnsupportedOperationException("Sequential streams are not supported for Hazelcast Jet");
    }

    @Override
    public DistributedStream<E_OUT> parallel() {
        return this;
    }

    @Override
    public DistributedStream<E_OUT> unordered() {
        if (this.isOrdered()) {
            return new UnorderedPipe(this.context, this);
        }
        return this;
    }

    @Override
    public DistributedStream<E_OUT> onClose(Runnable closeHandler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("Jet streams are not closeable.");
    }

    @Override
    public boolean isOrdered() {
        return this.isOrdered;
    }

    @Override
    public Spliterator<E_OUT> spliterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DistributedStream<E_OUT> configure(JobConfig jobConfig) {
        this.context.setJobConfig(jobConfig);
        return this;
    }
}

