/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream;

import com.hazelcast.jet.ICacheJet;
import com.hazelcast.jet.IListJet;
import com.hazelcast.jet.IMapJet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.accumulator.LongAccumulator;
import com.hazelcast.jet.accumulator.MutableReference;
import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.aggregate.AggregateOperations;
import com.hazelcast.jet.core.processor.SinkProcessors;
import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedBinaryOperator;
import com.hazelcast.jet.function.DistributedComparator;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedPredicate;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.function.DistributedToDoubleFunction;
import com.hazelcast.jet.function.DistributedToIntFunction;
import com.hazelcast.jet.function.DistributedToLongFunction;
import com.hazelcast.jet.stream.DistributedCollector;
import com.hazelcast.jet.stream.impl.distributed.DistributedDoubleSummaryStatistics;
import com.hazelcast.jet.stream.impl.distributed.DistributedIntSummaryStatistics;
import com.hazelcast.jet.stream.impl.distributed.DistributedLongSummaryStatistics;
import com.hazelcast.jet.stream.impl.reducers.DistributedCollectorImpl;
import com.hazelcast.jet.stream.impl.reducers.GroupingSinkReducer;
import com.hazelcast.jet.stream.impl.reducers.IListReducer;
import com.hazelcast.jet.stream.impl.reducers.MergingSinkReducer;
import com.hazelcast.jet.stream.impl.reducers.SinkReducer;
import java.util.Collection;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collector;

public abstract class DistributedCollectors {
    public static <T, C extends Collection<T>> DistributedCollector<T, ?, C> toCollection(DistributedSupplier<C> collectionSupplier) {
        return DistributedCollectors.aggregating(AggregateOperations.toCollection(collectionSupplier));
    }

    public static <T> DistributedCollector<T, ?, List<T>> toList() {
        return DistributedCollectors.aggregating(AggregateOperations.toList());
    }

    public static <T> DistributedCollector<T, ?, Set<T>> toSet() {
        return DistributedCollectors.aggregating(AggregateOperations.toSet());
    }

    public static DistributedCollector<CharSequence, ?, String> joining() {
        return DistributedCollectors.aggregating(AggregateOperations.concatenating());
    }

    public static DistributedCollector<CharSequence, ?, String> joining(CharSequence delimiter) {
        return DistributedCollectors.aggregating(AggregateOperations.concatenating(delimiter));
    }

    public static DistributedCollector<CharSequence, ?, String> joining(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return DistributedCollectors.aggregating(AggregateOperations.concatenating(delimiter, prefix, suffix));
    }

    public static <T, U, A, R> DistributedCollector<T, ?, R> mapping(DistributedFunction<? super T, ? extends U> mapper, DistributedCollector<? super U, A, R> downstream) {
        BiConsumer downstreamAccumulator = downstream.accumulator();
        return new DistributedCollectorImpl(downstream.supplier(), (arg_0, arg_1) -> DistributedCollectors.lambda$mapping$afed5416$1((DistributedBiConsumer)downstreamAccumulator, mapper, arg_0, arg_1), downstream.combiner(), downstream.finisher());
    }

    public static <T, A, I, R> DistributedCollector<T, A, R> collectingAndThen(DistributedCollector<T, A, I> downstream, DistributedFunction<I, R> finisher) {
        return new DistributedCollectorImpl(downstream.supplier(), downstream.accumulator(), downstream.combiner(), downstream.finisher().andThen(finisher));
    }

    public static <T> DistributedCollector<T, ?, Long> counting() {
        return DistributedCollectors.aggregating(AggregateOperations.counting());
    }

    public static <T> DistributedCollector<T, ?, Optional<T>> minBy(DistributedComparator<? super T> comparator) {
        return DistributedCollectors.reducing(DistributedBinaryOperator.minBy(comparator));
    }

    public static <T> DistributedCollector<T, ?, Optional<T>> maxBy(DistributedComparator<? super T> comparator) {
        return DistributedCollectors.reducing(DistributedBinaryOperator.maxBy(comparator));
    }

    public static <T> DistributedCollector<T, ?, Integer> summingInt(DistributedToIntFunction<? super T> mapper) {
        return new DistributedCollectorImpl(LongAccumulator::new, (a, t) -> a.addAllowingOverflow(mapper.applyAsInt(t)), LongAccumulator::addAllowingOverflow, a -> Math.toIntExact(a.get()));
    }

    public static <T> DistributedCollector<T, ?, Long> summingLong(DistributedToLongFunction<? super T> mapper) {
        return DistributedCollectors.aggregating(AggregateOperations.summingLong(mapper));
    }

    public static <T> DistributedCollector<T, ?, Double> summingDouble(DistributedToDoubleFunction<? super T> mapper) {
        return DistributedCollectors.aggregating(AggregateOperations.summingDouble(mapper));
    }

    public static <T> DistributedCollector<T, ?, Double> averagingInt(DistributedToIntFunction<? super T> mapper) {
        return DistributedCollectors.aggregating(AggregateOperations.averagingLong(mapper::applyAsInt));
    }

    public static <T> DistributedCollector<T, ?, Double> averagingLong(DistributedToLongFunction<? super T> mapper) {
        return DistributedCollectors.aggregating(AggregateOperations.averagingLong(mapper));
    }

    public static <T> DistributedCollector<T, ?, Double> averagingDouble(DistributedToDoubleFunction<? super T> mapper) {
        return DistributedCollectors.aggregating(AggregateOperations.averagingDouble(mapper));
    }

    public static <T> DistributedCollector<T, ?, T> reducing(T identity, DistributedBinaryOperator<T> op) {
        return new DistributedCollectorImpl(DistributedCollectors.refSupplier(identity), (ref, t) -> ref.set(op.apply(ref.get(), t)), (l, r) -> {
            l.set(op.apply(l.get(), r.get()));
            return l;
        }, MutableReference::get);
    }

    public static <T> DistributedCollector<T, ?, Optional<T>> reducing(DistributedBinaryOperator<T> op) {
        return new DistributedCollectorImpl(MutableReference::new, (ref, t) -> {
            Object lt = ref.get();
            if (lt == null) {
                ref.set(t);
            } else {
                ref.set(op.apply(lt, t));
            }
        }, (l, r) -> {
            Object lt = l.get();
            Object rt = r.get();
            if (lt == null) {
                l.set(rt);
            } else if (rt != null) {
                l.set(op.apply(lt, rt));
            }
            return l;
        }, a -> Optional.ofNullable(a.get()));
    }

    public static <T, U> DistributedCollector<T, ?, U> reducing(U identity, DistributedFunction<? super T, ? extends U> mapper, DistributedBinaryOperator<U> op) {
        return new DistributedCollectorImpl(DistributedCollectors.refSupplier(identity), (a, t) -> a.set(op.apply(a.get(), mapper.apply(t))), (a, b) -> {
            a.set(op.apply(a.get(), b.get()));
            return a;
        }, MutableReference::get);
    }

    public static <T, K> DistributedCollector<T, ?, Map<K, List<T>>> groupingBy(DistributedFunction<? super T, ? extends K> classifier) {
        return DistributedCollectors.groupingBy(classifier, DistributedCollectors.toList());
    }

    public static <T, K, A, D> DistributedCollector<T, ?, Map<K, D>> groupingBy(DistributedFunction<? super T, ? extends K> classifier, DistributedCollector<? super T, A, D> downstream) {
        return DistributedCollectors.groupingBy(classifier, HashMap::new, downstream);
    }

    public static <T, K, R, A, M extends Map<K, R>> DistributedCollector<T, ?, M> groupingBy(DistributedFunction<? super T, ? extends K> classifier, DistributedSupplier<M> mapFactory, DistributedCollector<? super T, A, R> downstream) {
        return DistributedCollectors.aggregating(AggregateOperations.groupingBy(classifier, mapFactory, DistributedCollectors.toAggregateOp(downstream)));
    }

    public static <T> Collector<T, ?, Map<Boolean, List<T>>> partitioningBy(DistributedPredicate<? super T> predicate) {
        return DistributedCollectors.partitioningBy(predicate, DistributedCollectors.toList());
    }

    public static <T, D, A> Collector<T, ?, Map<Boolean, D>> partitioningBy(DistributedPredicate<? super T> predicate, DistributedCollector<? super T, A, D> downstream) {
        return DistributedCollectors.groupingBy(predicate::test, downstream);
    }

    public static <T, K, U> DistributedCollector<T, ?, Map<K, U>> toMap(DistributedFunction<? super T, ? extends K> keyMapper, DistributedFunction<? super T, ? extends U> valueMapper) {
        return DistributedCollectors.aggregating(AggregateOperations.toMap(keyMapper, valueMapper));
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toMap(DistributedFunction<? super T, ? extends K> keyMapper, DistributedFunction<? super T, ? extends U> valueMapper, DistributedBinaryOperator<U> mergeFunction) {
        return DistributedCollectors.aggregating(AggregateOperations.toMap(keyMapper, valueMapper, mergeFunction));
    }

    public static <T, K, U, M extends Map<K, U>> DistributedCollector<T, ?, M> toMap(DistributedFunction<? super T, ? extends K> keyMapper, DistributedFunction<? super T, ? extends U> valueMapper, DistributedBinaryOperator<U> mergeFunction, DistributedSupplier<M> mapSupplier) {
        return DistributedCollectors.aggregating(AggregateOperations.toMap(keyMapper, valueMapper, mergeFunction, mapSupplier));
    }

    public static <T> DistributedCollector<T, ?, IntSummaryStatistics> summarizingInt(DistributedToIntFunction<? super T> mapper) {
        return new DistributedCollectorImpl(DistributedIntSummaryStatistics::new, (a, t) -> a.accept(mapper.applyAsInt(t)), (s1, s2) -> {
            s1.combine((IntSummaryStatistics)s2);
            return s1;
        });
    }

    public static <T> DistributedCollector<T, ?, LongSummaryStatistics> summarizingLong(DistributedToLongFunction<? super T> mapper) {
        return new DistributedCollectorImpl(DistributedLongSummaryStatistics::new, (a, t) -> a.accept(mapper.applyAsLong(t)), (s1, s2) -> {
            s1.combine((LongSummaryStatistics)s2);
            return s1;
        });
    }

    public static <T> DistributedCollector<T, ?, DoubleSummaryStatistics> summarizingDouble(DistributedToDoubleFunction<? super T> mapper) {
        return new DistributedCollectorImpl(DistributedDoubleSummaryStatistics::new, (a, t) -> a.accept(mapper.applyAsDouble(t)), (s1, s2) -> {
            s1.combine((DoubleSummaryStatistics)s2);
            return s1;
        });
    }

    public static <T, A, R> DistributedCollector<T, A, R> aggregating(AggregateOperation1<T, A, R> aggregateOp) {
        return new DistributedCollectorImpl(aggregateOp.createFn(), (acc, t) -> aggregateOp.accumulateFn().accept(acc, t), (l, r) -> {
            aggregateOp.combineFn().accept(l, r);
            return l;
        }, a -> aggregateOp.finishFn().apply(a));
    }

    private static <T, A, R> AggregateOperation1<? super T, A, R> toAggregateOp(DistributedCollector<? super T, A, R> collector) {
        return AggregateOperation.withCreate(collector.supplier()).andAccumulate(collector.accumulator()).andCombine((l, r) -> collector.combiner().apply(l, r)).andFinish(collector.finisher());
    }

    private static <T> DistributedSupplier<MutableReference<T>> refSupplier(T obj) {
        return () -> new MutableReference<Object>(obj);
    }

    public static <T, K, U> DistributedCollector.Reducer<T, IMapJet<K, U>> toIMap(String mapName, DistributedFunction<? super T, ? extends K> keyMapper, DistributedFunction<? super T, ? extends U> valueMapper) {
        return new SinkReducer("write-map-" + mapName, jetInstance -> jetInstance.getMap(mapName), keyMapper, valueMapper, SinkProcessors.writeMapP(mapName));
    }

    public static <K, U> DistributedCollector.Reducer<Map.Entry<K, U>, IMapJet<K, U>> toIMap(String mapName) {
        return DistributedCollectors.toIMap(mapName, Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T, K, U> DistributedCollector.Reducer<T, IMapJet<K, U>> toIMap(String mapName, DistributedFunction<? super T, ? extends K> keyMapper, DistributedFunction<? super T, ? extends U> valueMapper, DistributedBinaryOperator<U> mergeFunction) {
        return new MergingSinkReducer("write-map-" + mapName, jetInstance -> jetInstance.getMap(mapName), keyMapper, valueMapper, mergeFunction, SinkProcessors.writeMapP(mapName));
    }

    public static <T, K, U> DistributedCollector.Reducer<T, ICacheJet<K, U>> toICache(String cacheName, DistributedFunction<? super T, ? extends K> keyMapper, DistributedFunction<? super T, ? extends U> valueMapper) {
        return new SinkReducer("write-cache-" + cacheName, CacheGetter.getCacheFn(cacheName), keyMapper, valueMapper, SinkProcessors.writeCacheP(cacheName));
    }

    public static <K, U> DistributedCollector.Reducer<Map.Entry<K, U>, ICacheJet<K, U>> toICache(String cacheName) {
        return DistributedCollectors.toICache(cacheName, Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T, K, U> DistributedCollector.Reducer<T, ICacheJet<K, U>> toICache(String cacheName, DistributedFunction<? super T, ? extends K> keyMapper, DistributedFunction<? super T, ? extends U> valueMapper, DistributedBinaryOperator<U> mergeFunction) {
        return new MergingSinkReducer("write-cache-" + cacheName, CacheGetter.getCacheFn(cacheName), keyMapper, valueMapper, mergeFunction, SinkProcessors.writeCacheP(cacheName));
    }

    public static <T> DistributedCollector.Reducer<T, IListJet<T>> toIList(String listName) {
        return new IListReducer(listName);
    }

    public static <T, K> DistributedCollector.Reducer<T, IMapJet<K, List<T>>> groupingByToIMap(String mapName, DistributedFunction<? super T, ? extends K> classifier) {
        return DistributedCollectors.groupingByToIMap(mapName, classifier, DistributedCollectors.toList());
    }

    public static <T, K, A, D> DistributedCollector.Reducer<T, IMapJet<K, D>> groupingByToIMap(String mapName, DistributedFunction<? super T, ? extends K> classifier, DistributedCollector<? super T, A, D> downstream) {
        return new GroupingSinkReducer("write-map-" + mapName, jetInstance -> jetInstance.getMap(mapName), classifier, downstream, SinkProcessors.writeMapP(mapName));
    }

    public static <T, K> DistributedCollector.Reducer<T, ICacheJet<K, List<T>>> groupingByToICache(String cacheName, DistributedFunction<? super T, ? extends K> classifier) {
        return DistributedCollectors.groupingByToICache(cacheName, classifier, DistributedCollectors.toList());
    }

    public static <T, K, A, D> DistributedCollector.Reducer<T, ICacheJet<K, D>> groupingByToICache(String cacheName, DistributedFunction<? super T, ? extends K> classifier, DistributedCollector<? super T, A, D> downstream) {
        return new GroupingSinkReducer("write-cache-" + cacheName, CacheGetter.getCacheFn(cacheName), classifier, downstream, SinkProcessors.writeCacheP(cacheName));
    }

    private static /* synthetic */ void lambda$mapping$afed5416$1(DistributedBiConsumer downstreamAccumulator, DistributedFunction mapper, Object acc, Object item) {
        downstreamAccumulator.accept(acc, mapper.apply(item));
    }

    private static class CacheGetter {
        private CacheGetter() {
        }

        private static <K, V> DistributedFunction<JetInstance, ICacheJet<K, V>> getCacheFn(String name) {
            return instance -> instance.getCacheManager().getCache(name);
        }
    }
}

