/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.jet.Traverser;
import java.util.function.Function;

public class FlatMappingTraverser<T, R>
implements Traverser<R> {
    private static final Traverser NULL_TRAVERSER = new Traverser(){

        public Object next() {
            return null;
        }
    };
    private final Traverser<T> wrapped;
    private final Function<? super T, ? extends Traverser<? extends R>> mapper;
    private Traverser<? extends R> currentTraverser;

    public FlatMappingTraverser(Traverser<T> wrapped, Function<? super T, ? extends Traverser<? extends R>> mapper) {
        this.wrapped = wrapped;
        this.mapper = mapper;
        this.currentTraverser = this.nextTraverser();
    }

    @Override
    public R next() {
        do {
            R r;
            if ((r = this.currentTraverser.next()) != null) {
                return r;
            }
            this.currentTraverser = this.nextTraverser();
        } while (this.currentTraverser != NULL_TRAVERSER);
        return null;
    }

    private Traverser<? extends R> nextTraverser() {
        T t = this.wrapped.next();
        return t != null ? this.mapper.apply(t) : NULL_TRAVERSER;
    }
}

