/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.execution.ExecutionContext;
import com.hazelcast.jet.impl.operation.AsyncOperation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.function.BiConsumer;

public class StartExecutionOperation
extends AsyncOperation {
    private long executionId;

    public StartExecutionOperation() {
    }

    public StartExecutionOperation(long jobId, long executionId) {
        super(jobId);
        this.executionId = executionId;
    }

    @Override
    protected void doRun() throws Exception {
        ExecutionContext execCtx = this.getExecutionCtx();
        Address coordinator = this.getCallerAddress();
        this.getLogger().info("Start execution of " + Util.jobAndExecutionId(this.jobId(), this.executionId) + " from coordinator " + coordinator);
        execCtx.beginExecution().whenComplete((BiConsumer)ExceptionUtil.withTryCatch(this.getLogger(), (i, e) -> {
            if (e instanceof CancellationException) {
                this.getLogger().fine("Execution of " + Util.jobAndExecutionId(this.jobId(), this.executionId) + " was cancelled");
            } else if (e != null) {
                this.getLogger().fine("Execution of " + Util.jobAndExecutionId(this.jobId(), this.executionId) + " completed with failure", e);
            } else {
                this.getLogger().fine("Execution of " + Util.jobAndExecutionId(this.jobId(), this.executionId) + " completed");
            }
            this.doSendResponse(e);
        }));
    }

    private ExecutionContext getExecutionCtx() {
        JetService service = (JetService)this.getService();
        return service.getJobExecutionService().assertExecutionContext(this.getCallerAddress(), this.jobId(), this.executionId, this);
    }

    public int getId() {
        return 6;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.executionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.executionId = in.readLong();
    }
}

