/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.JetException;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.execution.ExecutionContext;
import com.hazelcast.jet.impl.operation.AsyncOperation;
import com.hazelcast.jet.impl.util.LoggingUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;

public class SnapshotOperation
extends AsyncOperation {
    private long executionId;
    private long snapshotId;

    public SnapshotOperation() {
    }

    public SnapshotOperation(long jobId, long executionId, long snapshotId) {
        super(jobId);
        this.executionId = executionId;
        this.snapshotId = snapshotId;
    }

    @Override
    protected void doRun() throws Exception {
        JetService service = (JetService)this.getService();
        ExecutionContext ctx = service.getJobExecutionService().assertExecutionContext(this.getCallerAddress(), this.jobId(), this.executionId, this);
        ctx.beginSnapshot(this.snapshotId).thenAccept(r -> {
            LoggingUtil.logFine(this.getLogger(), "Snapshot %s for job %s finished successfully on member", this.snapshotId, Util.idToString(this.jobId()));
            this.doSendResponse(null);
        }).exceptionally(e -> {
            this.getLogger().warning(String.format("Snapshot %d for job %s finished with error on member", this.snapshotId, Util.idToString(this.jobId())), e);
            this.doSendResponse((Object)new JetException("Exception during snapshot: " + e, (Throwable)e));
            return null;
        });
    }

    public int getId() {
        return 10;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.executionId);
        out.writeLong(this.snapshotId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.executionId = in.readLong();
        this.snapshotId = in.readLong();
    }
}

