/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class CompleteExecutionOperation
extends Operation
implements IdentifiedDataSerializable {
    private long executionId;
    private Throwable error;

    public CompleteExecutionOperation() {
    }

    public CompleteExecutionOperation(long executionId, Throwable error) {
        this.executionId = executionId;
        this.error = error;
    }

    public void run() throws Exception {
        ILogger logger = this.getLogger();
        JetService service = (JetService)this.getService();
        Address callerAddress = this.getCallerAddress();
        logger.fine("Completing execution " + Util.idToString(this.executionId) + " from caller: " + callerAddress + " with " + this.error);
        Address masterAddress = this.getNodeEngine().getMasterAddress();
        if (!callerAddress.equals((Object)masterAddress)) {
            throw new IllegalStateException("Caller " + callerAddress + " cannot complete execution of " + Util.idToString(this.executionId) + " because it is not master. Master is: " + masterAddress);
        }
        service.getJobExecutionService().completeExecution(this.executionId, this.error);
    }

    public ExceptionAction onInvocationException(Throwable throwable) {
        return ExceptionUtil.isTopologicalFailure(throwable) ? ExceptionAction.THROW_EXCEPTION : super.onInvocationException(throwable);
    }

    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    public int getId() {
        return 7;
    }

    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.executionId);
        out.writeObject((Object)this.error);
    }

    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.executionId = in.readLong();
        this.error = (Throwable)in.readObject();
    }
}

