/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.operation.AbstractJobOperation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.spi.ExceptionAction;

public abstract class AsyncOperation
extends AbstractJobOperation {
    protected AsyncOperation() {
    }

    protected AsyncOperation(long jobId) {
        super(jobId);
    }

    public void beforeRun() throws Exception {
        JetService service = (JetService)this.getService();
        service.getLiveOperationRegistry().register(this);
    }

    public final void run() throws Exception {
        try {
            this.doRun();
        }
        catch (Exception e) {
            this.logError(e);
            this.doSendResponse(e);
        }
    }

    protected abstract void doRun() throws Exception;

    public final boolean returnsResponse() {
        return false;
    }

    public final Object getResponse() {
        throw new UnsupportedOperationException();
    }

    public final void doSendResponse(Object value) {
        try {
            this.sendResponse(value);
        }
        finally {
            JetService service = (JetService)this.getService();
            service.getLiveOperationRegistry().deregister(this);
        }
    }

    public ExceptionAction onInvocationException(Throwable throwable) {
        return ExceptionUtil.isTopologicalFailure(throwable) ? ExceptionAction.THROW_EXCEPTION : super.onInvocationException(throwable);
    }
}

