/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution;

import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.execution.ReceiverTasklet;
import com.hazelcast.jet.impl.execution.SenderTasklet;
import com.hazelcast.jet.impl.execution.SnapshotContext;
import com.hazelcast.jet.impl.execution.Tasklet;
import com.hazelcast.jet.impl.execution.TaskletExecutionService;
import com.hazelcast.jet.impl.execution.init.ExecutionPlan;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class ExecutionContext {
    private final long jobId;
    private final long executionId;
    private final Address coordinator;
    private final Set<Address> participants;
    private final Object executionLock = new Object();
    private final ILogger logger;
    private Map<Integer, Map<Integer, Map<Address, ReceiverTasklet>>> receiverMap = Collections.emptyMap();
    private Map<Integer, Map<Integer, Map<Address, SenderTasklet>>> senderMap = Collections.emptyMap();
    private List<ProcessorSupplier> procSuppliers = Collections.emptyList();
    private List<Processor> processors = Collections.emptyList();
    private List<Tasklet> tasklets;
    private volatile CompletableFuture<Void> executionFuture;
    private final CompletableFuture<Void> cancellationFuture = new CompletableFuture();
    private final NodeEngine nodeEngine;
    private final TaskletExecutionService execService;
    private SnapshotContext snapshotContext;

    public ExecutionContext(NodeEngine nodeEngine, TaskletExecutionService execService, long jobId, long executionId, Address coordinator, Set<Address> participants) {
        this.jobId = jobId;
        this.executionId = executionId;
        this.coordinator = coordinator;
        this.participants = new HashSet<Address>(participants);
        this.execService = execService;
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(this.getClass());
    }

    public ExecutionContext initialize(ExecutionPlan plan) {
        this.procSuppliers = Collections.unmodifiableList(plan.getProcessorSuppliers());
        this.processors = plan.getProcessors();
        this.snapshotContext = new SnapshotContext(this.nodeEngine.getLogger(SnapshotContext.class), this.jobId, this.executionId, plan.lastSnapshotId(), plan.getJobConfig().getProcessingGuarantee());
        plan.initialize(this.nodeEngine, this.jobId, this.executionId, this.snapshotContext);
        this.snapshotContext.initTaskletCount(plan.getStoreSnapshotTaskletCount(), plan.getHigherPriorityVertexCount());
        this.receiverMap = Collections.unmodifiableMap(plan.getReceiverMap());
        this.senderMap = Collections.unmodifiableMap(plan.getSenderMap());
        this.tasklets = plan.getTasklets();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> beginExecution() {
        Object object = this.executionLock;
        synchronized (object) {
            if (this.executionFuture != null) {
                return this.executionFuture;
            }
            JetService service = (JetService)this.nodeEngine.getService("hz:impl:jetService");
            ClassLoader cl = service.getClassLoader(this.jobId);
            this.executionFuture = this.execService.beginExecute(this.tasklets, this.cancellationFuture, cl);
            return this.executionFuture;
        }
    }

    public void completeExecution(Throwable error) {
        assert (this.executionFuture == null || this.executionFuture.isDone()) : "If execution was begun, then completeExecution() should not be called before execution is done.";
        for (Processor processor : this.processors) {
            try {
                processor.close(error);
            }
            catch (Throwable e) {
                this.logger.severe(Util.jobAndExecutionId(this.jobId, this.executionId) + " encountered an exception in Processor.close(), ignoring it", e);
            }
        }
        for (ProcessorSupplier s : this.procSuppliers) {
            try {
                s.close(error);
            }
            catch (Throwable e) {
                this.logger.severe(Util.jobAndExecutionId(this.jobId, this.executionId) + " encountered an exception in ProcessorSupplier.complete(), ignoring it", e);
            }
        }
        MetricsRegistry metricsRegistry = ((NodeEngineImpl)this.nodeEngine).getMetricsRegistry();
        this.processors.forEach(arg_0 -> ((MetricsRegistry)metricsRegistry).deregister(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> cancelExecution() {
        Object object = this.executionLock;
        synchronized (object) {
            this.cancellationFuture.cancel(true);
            if (this.executionFuture == null) {
                this.executionFuture = this.cancellationFuture;
            }
            return this.executionFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Void> beginSnapshot(long snapshotId) {
        Object object = this.executionLock;
        synchronized (object) {
            if (this.cancellationFuture.isDone() || this.executionFuture != null && this.executionFuture.isDone()) {
                throw new CancellationException();
            }
            return this.snapshotContext.startNewSnapshot(snapshotId);
        }
    }

    public void handlePacket(int vertexId, int ordinal, Address sender, BufferObjectDataInput in) {
        this.receiverMap.get(vertexId).get(ordinal).get(sender).receiveStreamPacket(in);
    }

    public boolean hasParticipant(Address member) {
        return this.participants.contains(member);
    }

    public long jobId() {
        return this.jobId;
    }

    public long executionId() {
        return this.executionId;
    }

    public Address coordinator() {
        return this.coordinator;
    }

    public Map<Integer, Map<Integer, Map<Address, SenderTasklet>>> senderMap() {
        return this.senderMap;
    }

    public Map<Integer, Map<Integer, Map<Address, ReceiverTasklet>>> receiverMap() {
        return this.receiverMap;
    }

    public SnapshotContext snapshotContext() {
        return this.snapshotContext;
    }
}

