/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.deployment;

import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Enumeration;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.zip.InflaterInputStream;

public class JetClassLoader
extends ClassLoader {
    private static final String JOB_URL_PROTOCOL = "jet-job-resource";
    private final Map<String, byte[]> resources;

    public JetClassLoader(Map<String, byte[]> resources) {
        super(JetClassLoader.class.getClassLoader());
        this.resources = resources;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (JetClassLoader.isEmpty(name)) {
            return null;
        }
        InputStream classBytesStream = this.resourceStream(name.replace('.', '/') + ".class");
        if (classBytesStream == null) {
            throw new ClassNotFoundException(name + ". Add it using " + JobConfig.class.getSimpleName() + " or start all members with it on classpath");
        }
        byte[] classBytes = Util.uncheckCall(() -> IOUtil.toByteArray((InputStream)classBytesStream));
        return this.defineClass(name, classBytes, 0, classBytes.length);
    }

    @Override
    protected URL findResource(String name) {
        if (JetClassLoader.isEmpty(name) || !this.resources.containsKey(name)) {
            return null;
        }
        return Util.uncheckCall(() -> this.createResourceURL(name));
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return new SingleURLEnumeration(this.findResource(name));
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (JetClassLoader.isEmpty(name)) {
            return null;
        }
        return this.resourceStream(name);
    }

    private InputStream resourceStream(String name) {
        byte[] classData = this.resources.get(name);
        if (classData == null) {
            return null;
        }
        return new InflaterInputStream(new ByteArrayInputStream(classData));
    }

    private URL createResourceURL(String name) throws MalformedURLException {
        return new URL(JOB_URL_PROTOCOL, null, -1, name, new JobResourceURLStreamHandler());
    }

    private static boolean isEmpty(String className) {
        return className == null || className.isEmpty();
    }

    private static final class SingleURLEnumeration
    implements Enumeration<URL> {
        private URL url;

        private SingleURLEnumeration(URL url) {
            this.url = url;
        }

        @Override
        public boolean hasMoreElements() {
            return this.url != null;
        }

        @Override
        public URL nextElement() {
            if (this.url == null) {
                throw new NoSuchElementException();
            }
            try {
                URL uRL = this.url;
                return uRL;
            }
            finally {
                this.url = null;
            }
        }
    }

    private final class JobResourceURLConnection
    extends URLConnection {
        private JobResourceURLConnection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return JetClassLoader.this.resourceStream(this.url.getFile());
        }
    }

    private final class JobResourceURLStreamHandler
    extends URLStreamHandler {
        private JobResourceURLStreamHandler() {
        }

        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            return new JobResourceURLConnection(url);
        }
    }
}

