/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.connector.SerializableClientConfig;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ReadIListP
extends AbstractProcessor {
    static final int FETCH_SIZE = 16384;
    private final String name;
    private final SerializableClientConfig clientConfig;
    private Traverser<Object> traverser;
    private HazelcastInstance client;

    ReadIListP(String name, SerializableClientConfig clientConfig) {
        this.name = name;
        this.clientConfig = clientConfig;
    }

    @Override
    protected void init(@Nonnull Processor.Context context) {
        HazelcastInstance instance = this.isRemote() ? (this.client = HazelcastClient.newHazelcastClient((ClientConfig)this.clientConfig.asClientConfig())) : context.jetInstance().getHazelcastInstance();
        IList list = instance.getList(this.name);
        int size = list.size();
        this.traverser = size <= 16384 ? Traversers.traverseIterable(list) : Traversers.traverseStream(IntStream.rangeClosed(0, size / 16384).mapToObj(chunkIndex -> chunkIndex * 16384)).flatMap(start -> Traversers.traverseIterable(list.subList(start.intValue(), Math.min(start + 16384, size))));
    }

    @Override
    public boolean complete() {
        return this.emitFromTraverser(this.traverser);
    }

    @Override
    public boolean isCooperative() {
        return false;
    }

    @Override
    public void close(@Nullable Throwable error) {
        if (this.client != null) {
            this.client.shutdown();
        }
    }

    private boolean isRemote() {
        return this.clientConfig != null;
    }

    public static ProcessorMetaSupplier metaSupplier(String listName, ClientConfig clientConfig) {
        SerializableClientConfig config = clientConfig != null ? new SerializableClientConfig(clientConfig) : null;
        return ProcessorMetaSupplier.forceTotalParallelismOne(ProcessorSupplier.of(() -> new ReadIListP(listName, config)), listName);
    }
}

