/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.JobNotFoundException;
import com.hazelcast.jet.impl.AbstractJetInstance;
import com.hazelcast.jet.impl.JobProxy;
import com.hazelcast.jet.impl.operation.GetJobIdsByNameOperation;
import com.hazelcast.jet.impl.operation.GetJobIdsOperation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class JetInstanceImpl
extends AbstractJetInstance {
    private final NodeEngine nodeEngine;
    private final JetConfig config;

    public JetInstanceImpl(HazelcastInstanceImpl hazelcastInstance, JetConfig config) {
        super((HazelcastInstance)hazelcastInstance);
        this.nodeEngine = hazelcastInstance.node.getNodeEngine();
        this.config = config;
    }

    @Override
    @Nonnull
    public JetConfig getConfig() {
        return this.config;
    }

    @Override
    @Nonnull
    public Job newJob(@Nonnull DAG dag, @Nonnull JobConfig config) {
        long jobId = this.uploadResourcesAndAssignId(config);
        return new JobProxy((NodeEngineImpl)this.nodeEngine, jobId, dag, config);
    }

    @Override
    @Nonnull
    public List<Job> getJobs() {
        Address masterAddress = this.nodeEngine.getMasterAddress();
        InternalCompletableFuture future = this.nodeEngine.getOperationService().createInvocationBuilder("hz:impl:jetService", (Operation)new GetJobIdsOperation(), masterAddress).invoke();
        return Util.uncheckCall(() -> this.lambda$getJobs$1((Future)future));
    }

    @Override
    public Job getJob(long jobId) {
        try {
            JobProxy job = new JobProxy((NodeEngineImpl)this.nodeEngine, jobId);
            job.getStatus();
            return job;
        }
        catch (Exception e) {
            if (ExceptionUtil.peel(e) instanceof JobNotFoundException) {
                return null;
            }
            throw e;
        }
    }

    @Override
    @Nonnull
    public List<Job> getJobs(@Nonnull String name) {
        return this.getJobIdsByName(name).stream().map(jobId -> new JobProxy((NodeEngineImpl)this.nodeEngine, (long)jobId)).collect(Collectors.toList());
    }

    private List<Long> getJobIdsByName(String name) {
        Address masterAddress = this.nodeEngine.getMasterAddress();
        InternalCompletableFuture future = this.nodeEngine.getOperationService().createInvocationBuilder("hz:impl:jetService", (Operation)new GetJobIdsByNameOperation(name), masterAddress).invoke();
        return Util.uncheckCall(((Future)future)::get);
    }

    private /* synthetic */ List lambda$getJobs$1(Future future) throws Exception {
        return ((Set)future.get()).stream().map(jobId -> new JobProxy((NodeEngineImpl)this.nodeEngine, (long)jobId)).collect(Collectors.toList());
    }
}

