/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.JetCancelJobCodec;
import com.hazelcast.client.impl.protocol.codec.JetGetJobConfigCodec;
import com.hazelcast.client.impl.protocol.codec.JetGetJobStatusCodec;
import com.hazelcast.client.impl.protocol.codec.JetGetJobSubmissionTimeCodec;
import com.hazelcast.client.impl.protocol.codec.JetJoinSubmittedJobCodec;
import com.hazelcast.client.impl.protocol.codec.JetRestartJobCodec;
import com.hazelcast.client.impl.protocol.codec.JetSubmitJobCodec;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.Member;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.AbstractJobProxy;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.serialization.SerializationService;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;

public class ClientJobProxy
extends AbstractJobProxy<HazelcastClientInstanceImpl> {
    ClientJobProxy(HazelcastClientInstanceImpl client, long jobId) {
        super(client, jobId);
    }

    ClientJobProxy(HazelcastClientInstanceImpl client, long jobId, DAG dag, JobConfig config) {
        super(client, jobId, dag, config);
    }

    @Override
    @Nonnull
    public JobStatus getStatus() {
        ClientMessage request = JetGetJobStatusCodec.encodeRequest((long)this.getId());
        return Util.uncheckCall(() -> {
            ClientMessage response = (ClientMessage)this.invocation(request, this.masterAddress()).invoke().get();
            Data statusData = JetGetJobStatusCodec.decodeResponse((ClientMessage)response).response;
            return (JobStatus)((Object)((Object)this.serializationService().toObject((Object)statusData)));
        });
    }

    @Override
    public boolean restart() {
        try {
            ClientMessage request = JetRestartJobCodec.encodeRequest((long)this.getId());
            ClientMessage response = (ClientMessage)this.invocation(request, this.masterAddress()).invoke().get();
            return JetRestartJobCodec.decodeResponse((ClientMessage)response).response;
        }
        catch (InterruptedException | ExecutionException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    protected ICompletableFuture<Void> invokeSubmitJob(Data dag, JobConfig config) {
        Data configData = this.serializationService().toData((Object)config);
        ClientMessage request = JetSubmitJobCodec.encodeRequest((long)this.getId(), (Data)dag, (Data)configData);
        return new CancellableFuture(this.invocation(request, this.masterAddress()).invoke());
    }

    @Override
    protected ICompletableFuture<Void> invokeJoinJob() {
        ClientMessage request = JetJoinSubmittedJobCodec.encodeRequest((long)this.getId());
        return new CancellableFuture(this.invocation(request, this.masterAddress()).invoke());
    }

    @Override
    protected ICompletableFuture<Void> invokeCancelJob() {
        ClientMessage request = JetCancelJobCodec.encodeRequest((long)this.getId());
        return new CancellableFuture(this.invocation(request, this.masterAddress()).invoke());
    }

    @Override
    protected long doGetJobSubmissionTime() {
        ClientMessage request = JetGetJobSubmissionTimeCodec.encodeRequest((long)this.getId());
        return Util.uncheckCall(() -> {
            ClientMessage response = (ClientMessage)this.invocation(request, this.masterAddress()).invoke().get();
            return JetGetJobSubmissionTimeCodec.decodeResponse((ClientMessage)response).response;
        });
    }

    @Override
    protected JobConfig doGetJobConfig() {
        ClientMessage request = JetGetJobConfigCodec.encodeRequest((long)this.getId());
        return Util.uncheckCall(() -> {
            ClientMessage response = (ClientMessage)this.invocation(request, this.masterAddress()).invoke().get();
            Data data = JetGetJobConfigCodec.decodeResponse((ClientMessage)response).response;
            return (JobConfig)this.serializationService().toObject((Object)data);
        });
    }

    @Override
    protected Address masterAddress() {
        Optional first = ((HazelcastClientInstanceImpl)this.container()).getCluster().getMembers().stream().findFirst();
        return ((Member)first.orElseThrow(() -> new IllegalStateException("No members found in cluster"))).getAddress();
    }

    @Override
    protected SerializationService serializationService() {
        return ((HazelcastClientInstanceImpl)this.container()).getSerializationService();
    }

    @Override
    protected LoggingService loggingService() {
        return ((HazelcastClientInstanceImpl)this.container()).getLoggingService();
    }

    private ClientInvocation invocation(ClientMessage request, Address invocationAddr) {
        return new ClientInvocation((HazelcastClientInstanceImpl)this.container(), request, this.jobName(), invocationAddr);
    }

    private String jobName() {
        return "jobId=" + Util.idToString(this.getId());
    }

    private static class CancellableFuture<T>
    implements ICompletableFuture<Void> {
        private final ICompletableFuture<T> future;

        CancellableFuture(ICompletableFuture<T> future) {
            this.future = future;
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        public boolean isDone() {
            return this.future.isDone();
        }

        public Void get() throws InterruptedException, ExecutionException {
            this.future.get();
            return null;
        }

        public Void get(long timeout, @Nonnull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.future.get(timeout, unit);
            return null;
        }

        public void andThen(final ExecutionCallback<Void> callback) {
            this.future.andThen(new ExecutionCallback<T>(){

                public void onResponse(T response) {
                    callback.onResponse(null);
                }

                public void onFailure(Throwable t) {
                    callback.onFailure(t);
                }
            });
        }

        public void andThen(final ExecutionCallback<Void> callback, Executor executor) {
            this.future.andThen(new ExecutionCallback<T>(){

                public void onResponse(T response) {
                    callback.onResponse(null);
                }

                public void onFailure(Throwable t) {
                    callback.onFailure(t);
                }
            }, executor);
        }
    }
}

