/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.function;

import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedToDoubleFunction;
import com.hazelcast.jet.function.DistributedToIntFunction;
import com.hazelcast.jet.function.DistributedToLongFunction;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.stream.impl.distributed.DistributedComparators;
import com.hazelcast.util.Preconditions;
import java.io.Serializable;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

@FunctionalInterface
public interface DistributedComparator<T>
extends Comparator<T>,
Serializable {
    public static <T extends Comparable<? super T>> DistributedComparator<T> naturalOrder() {
        return DistributedComparators.NATURAL_ORDER;
    }

    public static <T extends Comparable<? super T>> DistributedComparator<T> reverseOrder() {
        return DistributedComparators.REVERSE_ORDER;
    }

    public static <T> DistributedComparator<T> nullsFirst(Comparator<? super T> comparator) {
        Util.checkSerializable(comparator, "comparator");
        DistributedComparators.NullComparator c = new DistributedComparators.NullComparator(true);
        return comparator != null ? c.thenComparing((Comparator)comparator) : c;
    }

    public static <T> DistributedComparator<T> nullsFirst(DistributedComparator<? super T> comparator) {
        return DistributedComparator.nullsFirst(comparator);
    }

    public static <T> DistributedComparator<T> nullsLast(Comparator<? super T> comparator) {
        Util.checkSerializable(comparator, "comparator");
        DistributedComparators.NullComparator c = new DistributedComparators.NullComparator(false);
        return comparator != null ? c.thenComparing((Comparator)comparator) : c;
    }

    public static <T> DistributedComparator<T> nullsLast(DistributedComparator<? super T> comparator) {
        return DistributedComparator.nullsLast(comparator);
    }

    public static <T, U> DistributedComparator<T> comparing(Function<? super T, ? extends U> toKeyFn, Comparator<? super U> keyComparator) {
        Preconditions.checkNotNull(toKeyFn, (String)"toKeyFn");
        Preconditions.checkNotNull(keyComparator, (String)"keyComparator");
        Util.checkSerializable(toKeyFn, "toKeyFn");
        Util.checkSerializable(keyComparator, "keyComparator");
        return (c1, c2) -> keyComparator.compare((Object)toKeyFn.apply(c1), (Object)toKeyFn.apply(c2));
    }

    public static <T, U> DistributedComparator<T> comparing(DistributedFunction<? super T, ? extends U> toKeyFn, DistributedComparator<? super U> keyComparator) {
        return DistributedComparator.comparing(toKeyFn, keyComparator);
    }

    public static <T, U extends Comparable<? super U>> DistributedComparator<T> comparing(Function<? super T, ? extends U> toKeyFn) {
        Preconditions.checkNotNull(toKeyFn, (String)"toKeyFn");
        Util.checkSerializable(toKeyFn, "toKeyFn");
        return (left, right) -> ((Comparable)toKeyFn.apply(left)).compareTo(toKeyFn.apply(right));
    }

    public static <T, U extends Comparable<? super U>> DistributedComparator<T> comparing(DistributedFunction<? super T, ? extends U> toKeyFn) {
        return DistributedComparator.comparing(toKeyFn);
    }

    public static <T> DistributedComparator<T> comparingInt(ToIntFunction<? super T> toKeyFn) {
        Preconditions.checkNotNull(toKeyFn, (String)"toKeyFn");
        Util.checkSerializable(toKeyFn, "toKeyFn");
        return (c1, c2) -> Integer.compare(toKeyFn.applyAsInt(c1), toKeyFn.applyAsInt(c2));
    }

    public static <T> DistributedComparator<T> comparingInt(DistributedToIntFunction<? super T> toKeyFn) {
        return DistributedComparator.comparingInt(toKeyFn);
    }

    public static <T> DistributedComparator<T> comparingLong(ToLongFunction<? super T> toKeyFn) {
        Preconditions.checkNotNull(toKeyFn, (String)"toKeyFn");
        Util.checkSerializable(toKeyFn, "toKeyFn");
        return (c1, c2) -> Long.compare(toKeyFn.applyAsLong(c1), toKeyFn.applyAsLong(c2));
    }

    public static <T> DistributedComparator<T> comparingLong(DistributedToLongFunction<? super T> toKeyFn) {
        return DistributedComparator.comparingLong(toKeyFn);
    }

    public static <T> DistributedComparator<T> comparingDouble(ToDoubleFunction<? super T> toKeyFn) {
        Preconditions.checkNotNull(toKeyFn, (String)"toKeyFn");
        Util.checkSerializable(toKeyFn, "toKeyFn");
        return (c1, c2) -> Double.compare(toKeyFn.applyAsDouble(c1), toKeyFn.applyAsDouble(c2));
    }

    public static <T> DistributedComparator<T> comparingDouble(DistributedToDoubleFunction<? super T> toKeyFn) {
        return DistributedComparator.comparingDouble(toKeyFn);
    }

    @Override
    default public DistributedComparator<T> thenComparing(Comparator<? super T> other) {
        Preconditions.checkNotNull(other, (String)"other");
        Util.checkSerializable(other, "other");
        return (c1, c2) -> {
            int res = this.compare(c1, c2);
            return res != 0 ? res : other.compare(c1, c2);
        };
    }

    @Override
    default public DistributedComparator<T> thenComparing(DistributedComparator<? super T> other) {
        return this.thenComparing((Comparator)other);
    }

    @Override
    default public <U> DistributedComparator<T> thenComparing(Function<? super T, ? extends U> toKeyFn, Comparator<? super U> keyComparator) {
        Util.checkSerializable(toKeyFn, "toKeyFn");
        Util.checkSerializable(keyComparator, "keyComparator");
        return this.thenComparing(DistributedComparator.comparing(toKeyFn, keyComparator));
    }

    @Override
    default public <U> DistributedComparator<T> thenComparing(DistributedFunction<? super T, ? extends U> toKeyFn, DistributedComparator<? super U> keyComparator) {
        return this.thenComparing((Function)toKeyFn, (Comparator)keyComparator);
    }

    @Override
    default public <U extends Comparable<? super U>> DistributedComparator<T> thenComparing(Function<? super T, ? extends U> toKeyFn) {
        Util.checkSerializable(toKeyFn, "toKeyFn");
        return this.thenComparing(DistributedComparator.comparing(toKeyFn));
    }

    @Override
    default public <U extends Comparable<? super U>> DistributedComparator<T> thenComparing(DistributedFunction<? super T, ? extends U> toKeyFn) {
        return this.thenComparing((Function)toKeyFn);
    }

    @Override
    default public DistributedComparator<T> thenComparingInt(ToIntFunction<? super T> toKeyFn) {
        Util.checkSerializable(toKeyFn, "toKeyFn");
        return this.thenComparing(DistributedComparator.comparingInt(toKeyFn));
    }

    @Override
    default public DistributedComparator<T> thenComparingInt(DistributedToIntFunction<? super T> toKeyFn) {
        return this.thenComparingInt((ToIntFunction)toKeyFn);
    }

    @Override
    default public DistributedComparator<T> thenComparingLong(ToLongFunction<? super T> toKeyFn) {
        Util.checkSerializable(toKeyFn, "toKeyFn");
        return this.thenComparing(DistributedComparator.comparingLong(toKeyFn));
    }

    @Override
    default public DistributedComparator<T> thenComparingLong(DistributedToLongFunction<? super T> toKeyFn) {
        return this.thenComparingLong((ToLongFunction)toKeyFn);
    }

    @Override
    default public DistributedComparator<T> thenComparingDouble(ToDoubleFunction<? super T> toKeyFn) {
        Util.checkSerializable(toKeyFn, "toKeyFn");
        return this.thenComparing(DistributedComparator.comparingDouble(toKeyFn));
    }

    @Override
    default public DistributedComparator<T> thenComparingDouble(DistributedToDoubleFunction<? super T> toKeyFn) {
        return this.thenComparingDouble((ToDoubleFunction)toKeyFn);
    }

    @Override
    default public DistributedComparator<T> reversed() {
        return (o1, o2) -> this.compare(o2, o1);
    }
}

