/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.datamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class TwoBags<T0, T1> {
    private final Collection<T0> bag0;
    private final Collection<T1> bag1;

    private TwoBags(@Nonnull Collection<T0> bag0, @Nonnull Collection<T1> bag1) {
        this.bag0 = new ArrayList<T0>(bag0);
        this.bag1 = new ArrayList<T1>(bag1);
    }

    @Nonnull
    public static <E0, E1> TwoBags<E0, E1> twoBags() {
        return new TwoBags(Collections.emptyList(), Collections.emptyList());
    }

    @Nonnull
    public static <E0, E1> TwoBags<E0, E1> twoBags(@Nonnull Collection<E0> bag0, @Nonnull Collection<E1> bag1) {
        return new TwoBags<E0, E1>(bag0, bag1);
    }

    @Nonnull
    public Collection<T0> bag0() {
        return this.bag0;
    }

    @Nonnull
    public Collection<T1> bag1() {
        return this.bag1;
    }

    public void combineWith(@Nonnull TwoBags<T0, T1> that) {
        this.bag0.addAll(that.bag0());
        this.bag1.addAll(that.bag1());
    }

    public void deduct(@Nonnull TwoBags<T0, T1> that) {
        this.bag0.removeAll(that.bag0());
        this.bag1.removeAll(that.bag1());
    }

    public TwoBags<T0, T1> finish() {
        return new TwoBags<T0, T1>(new ArrayList<T0>(this.bag0), new ArrayList<T1>(this.bag1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof TwoBags)) return false;
        TwoBags that = (TwoBags)o;
        if (!Objects.equals(this.bag0, that.bag0)) return false;
        if (!Objects.equals(this.bag1, that.bag1)) return false;
        return true;
    }

    public int hashCode() {
        int hc = Objects.hashCode(this.bag0);
        hc = 73 * hc + Objects.hashCode(this.bag1);
        return hc;
    }

    public String toString() {
        return "TwoBags{bag0=" + this.bag0 + ", bag1=" + this.bag1 + '}';
    }
}

