/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.datamodel;

import com.hazelcast.jet.impl.util.Util;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class TimestampedItem<T>
implements Serializable {
    private final long timestamp;
    private final T item;

    public TimestampedItem(long timestamp, @Nonnull T item) {
        this.timestamp = timestamp;
        this.item = item;
    }

    public TimestampedItem(long ignored, long timestamp, @Nonnull T item) {
        this(timestamp, item);
    }

    public long timestamp() {
        return this.timestamp;
    }

    public T item() {
        return this.item;
    }

    public int hashCode() {
        int hc = 17;
        hc = 73 * hc + Long.hashCode(this.timestamp);
        hc = 73 * hc + Objects.hashCode(this.item);
        return hc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof TimestampedItem)) return false;
        TimestampedItem that = (TimestampedItem)obj;
        if (this.timestamp != that.timestamp) return false;
        if (!Objects.equals(this.item, that.item)) return false;
        return true;
    }

    public String toString() {
        return "TimestampedItem{ts=" + Util.toLocalTime(this.timestamp) + ", value='" + this.item + "'}";
    }
}

