/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core.processor;

import com.hazelcast.cache.journal.EventJournalCacheEvent;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.WatermarkGenerationParams;
import com.hazelcast.jet.function.DistributedBiFunction;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedPredicate;
import com.hazelcast.jet.impl.connector.ReadFilesP;
import com.hazelcast.jet.impl.connector.ReadIListP;
import com.hazelcast.jet.impl.connector.ReadWithPartitionIteratorP;
import com.hazelcast.jet.impl.connector.StreamEventJournalP;
import com.hazelcast.jet.impl.connector.StreamFilesP;
import com.hazelcast.jet.impl.connector.StreamSocketP;
import com.hazelcast.jet.pipeline.JournalInitialPosition;
import com.hazelcast.map.journal.EventJournalMapEvent;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.Predicate;
import java.nio.charset.Charset;
import java.util.Map;
import javax.annotation.Nonnull;

public final class SourceProcessors {
    private SourceProcessors() {
    }

    @Nonnull
    public static ProcessorMetaSupplier readMapP(@Nonnull String mapName) {
        return ReadWithPartitionIteratorP.readMapP(mapName);
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier readMapP(@Nonnull String mapName, @Nonnull Predicate<K, V> predicate, @Nonnull Projection<Map.Entry<K, V>, T> projectionFn) {
        return ReadWithPartitionIteratorP.readMapP(mapName, predicate, projectionFn);
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier readMapP(@Nonnull String mapName, @Nonnull Predicate<K, V> predicate, @Nonnull DistributedFunction<Map.Entry<K, V>, T> projectionFn) {
        return ReadWithPartitionIteratorP.readMapP(mapName, predicate, SourceProcessors.toProjection(projectionFn));
    }

    @Nonnull
    public static <K, V> ProcessorMetaSupplier streamMapP(@Nonnull String mapName, @Nonnull JournalInitialPosition initialPos, WatermarkGenerationParams<Map.Entry<K, V>> wmGenParams) {
        return SourceProcessors.streamMapP(mapName, Util.mapPutEvents(), Util.mapEventToEntry(), initialPos, wmGenParams);
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier streamMapP(@Nonnull String mapName, @Nonnull DistributedPredicate<EventJournalMapEvent<K, V>> predicateFn, @Nonnull DistributedFunction<EventJournalMapEvent<K, V>, T> projectionFn, @Nonnull JournalInitialPosition initialPos, WatermarkGenerationParams<? super T> wmGenParams) {
        return StreamEventJournalP.streamMapP(mapName, predicateFn, projectionFn, initialPos, wmGenParams);
    }

    @Nonnull
    public static ProcessorMetaSupplier readRemoteMapP(@Nonnull String mapName, @Nonnull ClientConfig clientConfig) {
        return ReadWithPartitionIteratorP.readRemoteMapP(mapName, clientConfig);
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier readRemoteMapP(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull Predicate<K, V> predicate, @Nonnull Projection<Map.Entry<K, V>, T> projection) {
        return ReadWithPartitionIteratorP.readRemoteMapP(mapName, clientConfig, projection, predicate);
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier readRemoteMapP(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull Predicate<K, V> predicate, @Nonnull DistributedFunction<Map.Entry<K, V>, T> projectionFn) {
        return ReadWithPartitionIteratorP.readRemoteMapP(mapName, clientConfig, SourceProcessors.toProjection(projectionFn), predicate);
    }

    @Nonnull
    public static <K, V> ProcessorMetaSupplier streamRemoteMapP(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull JournalInitialPosition initialPos, WatermarkGenerationParams<Map.Entry<K, V>> wmGenParams) {
        return SourceProcessors.streamRemoteMapP(mapName, clientConfig, Util.mapPutEvents(), Util.mapEventToEntry(), initialPos, wmGenParams);
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier streamRemoteMapP(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull DistributedPredicate<EventJournalMapEvent<K, V>> predicateFn, @Nonnull DistributedFunction<EventJournalMapEvent<K, V>, T> projectionFn, @Nonnull JournalInitialPosition initialPos, @Nonnull WatermarkGenerationParams<T> wmGenParams) {
        return StreamEventJournalP.streamRemoteMapP(mapName, clientConfig, predicateFn, projectionFn, initialPos, wmGenParams);
    }

    @Nonnull
    public static ProcessorMetaSupplier readCacheP(@Nonnull String cacheName) {
        return ReadWithPartitionIteratorP.readCacheP(cacheName);
    }

    @Nonnull
    public static <K, V> ProcessorMetaSupplier streamCacheP(@Nonnull String cacheName, @Nonnull JournalInitialPosition initialPos, @Nonnull WatermarkGenerationParams<Map.Entry<K, V>> wmGenParams) {
        return SourceProcessors.streamCacheP(cacheName, Util.cachePutEvents(), Util.cacheEventToEntry(), initialPos, wmGenParams);
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier streamCacheP(@Nonnull String cacheName, @Nonnull DistributedPredicate<EventJournalCacheEvent<K, V>> predicateFn, @Nonnull DistributedFunction<EventJournalCacheEvent<K, V>, T> projectionFn, @Nonnull JournalInitialPosition initialPos, @Nonnull WatermarkGenerationParams<T> wmGenParams) {
        return StreamEventJournalP.streamCacheP(cacheName, predicateFn, projectionFn, initialPos, wmGenParams);
    }

    @Nonnull
    public static ProcessorMetaSupplier readRemoteCacheP(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig) {
        return ReadWithPartitionIteratorP.readRemoteCacheP(cacheName, clientConfig);
    }

    @Nonnull
    public static <K, V> ProcessorMetaSupplier streamRemoteCacheP(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig, @Nonnull JournalInitialPosition initialPos, @Nonnull WatermarkGenerationParams<Map.Entry<K, V>> wmGenParams) {
        return SourceProcessors.streamRemoteCacheP(cacheName, clientConfig, Util.cachePutEvents(), Util.cacheEventToEntry(), initialPos, wmGenParams);
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier streamRemoteCacheP(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig, @Nonnull DistributedPredicate<EventJournalCacheEvent<K, V>> predicateFn, @Nonnull DistributedFunction<EventJournalCacheEvent<K, V>, T> projectionFn, @Nonnull JournalInitialPosition initialPos, @Nonnull WatermarkGenerationParams<T> wmGenParams) {
        return StreamEventJournalP.streamRemoteCacheP(cacheName, clientConfig, predicateFn, projectionFn, initialPos, wmGenParams);
    }

    @Nonnull
    public static ProcessorMetaSupplier readListP(@Nonnull String listName) {
        return ReadIListP.metaSupplier(listName, null);
    }

    @Nonnull
    public static ProcessorMetaSupplier readRemoteListP(@Nonnull String listName, @Nonnull ClientConfig clientConfig) {
        return ReadIListP.metaSupplier(listName, clientConfig);
    }

    @Nonnull
    public static ProcessorMetaSupplier streamSocketP(@Nonnull String host, int port, @Nonnull Charset charset) {
        return StreamSocketP.supplier(host, port, charset.name());
    }

    @Nonnull
    public static ProcessorMetaSupplier readFilesP(@Nonnull String directory, @Nonnull Charset charset, @Nonnull String glob, @Nonnull DistributedBiFunction<String, String, ?> mapOutputFn) {
        return ReadFilesP.metaSupplier(directory, charset.name(), glob, mapOutputFn);
    }

    public static ProcessorMetaSupplier streamFilesP(@Nonnull String watchedDirectory, @Nonnull Charset charset, @Nonnull String glob, @Nonnull DistributedBiFunction<String, String, ?> mapOutputFn) {
        return StreamFilesP.metaSupplier(watchedDirectory, charset.name(), glob, mapOutputFn);
    }

    private static <I, O> Projection<I, O> toProjection(final DistributedFunction<I, O> projectionFn) {
        return new Projection<I, O>(){

            public O transform(I input) {
                return projectionFn.apply(input);
            }
        };
    }
}

