/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.jet.core.WatermarkPolicy;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.impl.util.WatermarkPolicyUtil;
import com.hazelcast.util.Preconditions;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public final class WatermarkPolicies {
    private WatermarkPolicies() {
    }

    @Nonnull
    public static DistributedSupplier<WatermarkPolicy> limitingLag(final long lag) {
        Preconditions.checkNotNegative((long)lag, (String)"lag must not be negative");
        return () -> new WatermarkPolicyUtil.WatermarkPolicyBase(){

            @Override
            public long reportEvent(long timestamp) {
                if (timestamp < Long.MIN_VALUE + lag) {
                    return Long.MIN_VALUE;
                }
                return this.makeWmAtLeast(timestamp - lag);
            }
        };
    }

    @Nonnull
    public static DistributedSupplier<WatermarkPolicy> limitingLagAndDelay(long lag, long maxDelayMs) {
        return () -> WatermarkPolicyUtil.limitingLagAndDelay(lag, TimeUnit.MILLISECONDS.toNanos(maxDelayMs), 16, System::nanoTime);
    }

    @Nonnull
    public static DistributedSupplier<WatermarkPolicy> limitingTimestampAndWallClockLag(long timestampLag, long wallClockLag) {
        return () -> WatermarkPolicyUtil.limitingTimestampAndWallClockLag(timestampLag, wallClockLag, System::currentTimeMillis);
    }

    @Nonnull
    public static DistributedSupplier<WatermarkPolicy> limitingLagAndLull(long lag, long maxLullMs) {
        return () -> WatermarkPolicyUtil.limitingLagAndLull(lag, maxLullMs, System::nanoTime);
    }
}

