/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.impl.SerializationConstants;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.Preconditions;
import java.io.IOException;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;

public class Vertex
implements IdentifiedDataSerializable {
    public static final int LOCAL_PARALLELISM_USE_DEFAULT = -1;
    private ProcessorMetaSupplier metaSupplier;
    private String name;
    private int localParallelism = -1;

    Vertex() {
    }

    public Vertex(@Nonnull String name, @Nonnull DistributedSupplier<? extends Processor> processorSupplier) {
        this(name, ProcessorMetaSupplier.of(processorSupplier));
    }

    public Vertex(@Nonnull String name, @Nonnull ProcessorSupplier processorSupplier) {
        this(name, ProcessorMetaSupplier.of(processorSupplier));
    }

    public Vertex(@Nonnull String name, @Nonnull ProcessorMetaSupplier metaSupplier) {
        Preconditions.checkNotNull((Object)name, (String)"name");
        Preconditions.checkNotNull((Object)metaSupplier, (String)"supplier");
        Util.checkSerializable(metaSupplier, "metaSupplier");
        this.metaSupplier = metaSupplier;
        this.name = name;
    }

    public static int checkLocalParallelism(int parallelism) {
        if (parallelism != -1 && parallelism <= 0) {
            throw new IllegalArgumentException("Parallelism must be either -1 or a positive number");
        }
        return parallelism;
    }

    @Nonnull
    public Vertex localParallelism(int localParallelism) {
        this.localParallelism = Vertex.checkLocalParallelism(localParallelism);
        return this;
    }

    public int getLocalParallelism() {
        return this.localParallelism;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public ProcessorMetaSupplier getMetaSupplier() {
        return this.metaSupplier;
    }

    public void updateMetaSupplier(@Nonnull UnaryOperator<ProcessorMetaSupplier> updateFn) {
        this.metaSupplier = (ProcessorMetaSupplier)updateFn.apply(this.metaSupplier);
    }

    public String toString() {
        return "Vertex " + this.name;
    }

    public void writeData(@Nonnull ObjectDataOutput out) throws IOException {
        out.writeInt(this.localParallelism);
        out.writeUTF(this.name);
        CustomClassLoadedObject.write(out, this.metaSupplier);
    }

    public void readData(@Nonnull ObjectDataInput in) throws IOException {
        this.localParallelism = in.readInt();
        this.name = in.readUTF();
        this.metaSupplier = (ProcessorMetaSupplier)CustomClassLoadedObject.read(in);
    }

    public int getFactoryId() {
        return SerializationConstants.FACTORY_ID;
    }

    public int getId() {
        return 1;
    }
}

