/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.impl.SerializationConstants;
import com.hazelcast.jet.impl.TopologicalSorter;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class DAG
implements IdentifiedDataSerializable,
Iterable<Vertex> {
    private Set<Edge> edges = new LinkedHashSet<Edge>();
    private Map<String, Vertex> nameToVertex = new HashMap<String, Vertex>();
    private Set<Vertex> verticesByIdentity = Collections.newSetFromMap(new IdentityHashMap());

    public Vertex newVertex(String name, DistributedSupplier<? extends Processor> simpleSupplier) {
        return this.addVertex(new Vertex(name, simpleSupplier));
    }

    public Vertex newVertex(String name, ProcessorSupplier processorSupplier) {
        return this.addVertex(new Vertex(name, processorSupplier));
    }

    public Vertex newVertex(String name, ProcessorMetaSupplier metaSupplier) {
        return this.addVertex(new Vertex(name, metaSupplier));
    }

    public DAG vertex(Vertex vertex) {
        this.addVertex(vertex);
        return this;
    }

    public DAG edge(Edge edge) {
        if (edge.getDestination() == null) {
            throw new IllegalArgumentException("Edge has no destination");
        }
        if (this.edges.contains(edge)) {
            throw new IllegalArgumentException("This DAG already has an edge between '" + edge.getSourceName() + "' and '" + edge.getDestName() + '\'');
        }
        if (!this.containsVertex(edge.getSource())) {
            throw new IllegalArgumentException(this.containsVertexName(edge.getSource()) ? "This DAG has a vertex called '" + edge.getSourceName() + "', but the supplied edge's source is a different vertex with the same name" : "Source vertex '" + edge.getSourceName() + "' is not in this DAG");
        }
        if (!this.containsVertex(edge.getDestination())) {
            throw new IllegalArgumentException(this.containsVertexName(edge.getDestination()) ? "This DAG has a vertex called '" + edge.getDestName() + "', but the supplied edge's destination is a different vertex with the same name" : "Destination vertex '" + edge.getDestName() + "' is not in this DAG");
        }
        if (this.getInboundEdges(edge.getDestName()).stream().anyMatch(e -> e.getDestOrdinal() == edge.getDestOrdinal())) {
            throw new IllegalArgumentException("Vertex '" + edge.getDestName() + "' already has an inbound edge at ordinal " + edge.getDestOrdinal() + (edge.getSourceOrdinal() == 0 && edge.getDestOrdinal() == 0 ? ", use Edge.from().to() to specify another ordinal" : ""));
        }
        if (this.getOutboundEdges(edge.getSourceName()).stream().anyMatch(e -> e.getSourceOrdinal() == edge.getSourceOrdinal())) {
            throw new IllegalArgumentException("Vertex '" + edge.getSourceName() + "' already has an outbound edge at ordinal " + edge.getSourceOrdinal() + (edge.getSourceOrdinal() == 0 && edge.getDestOrdinal() == 0 ? ", use Edge.from().to() to specify another ordinal" : ""));
        }
        if (edge.getSource() == edge.getDestination()) {
            throw new IllegalArgumentException("Attempted to add an edge from " + edge.getSourceName() + " to itself");
        }
        this.edges.add(edge);
        return this;
    }

    public List<Edge> getInboundEdges(String vertexName) {
        if (!this.nameToVertex.containsKey(vertexName)) {
            throw new IllegalArgumentException("No vertex with name '" + vertexName + "' found in this DAG");
        }
        ArrayList<Edge> inboundEdges = new ArrayList<Edge>();
        for (Edge edge : this.edges) {
            if (!edge.getDestName().equals(vertexName)) continue;
            inboundEdges.add(edge);
        }
        return inboundEdges;
    }

    public List<Edge> getOutboundEdges(String vertexName) {
        if (!this.nameToVertex.containsKey(vertexName)) {
            throw new IllegalArgumentException("No vertex with name '" + vertexName + "' found in this DAG");
        }
        ArrayList<Edge> outboundEdges = new ArrayList<Edge>();
        for (Edge edge : this.edges) {
            if (!edge.getSourceName().equals(vertexName)) continue;
            outboundEdges.add(edge);
        }
        return outboundEdges;
    }

    public Vertex getVertex(String vertexName) {
        return this.nameToVertex.get(vertexName);
    }

    @Override
    public Iterator<Vertex> iterator() {
        return this.validate().iterator();
    }

    private Vertex addVertex(Vertex vertex) {
        if (this.nameToVertex.containsKey(vertex.getName())) {
            throw new IllegalArgumentException("Vertex " + vertex.getName() + " is already defined.");
        }
        this.verticesByIdentity.add(vertex);
        this.nameToVertex.put(vertex.getName(), vertex);
        return vertex;
    }

    private boolean containsVertex(Vertex vertex) {
        return this.verticesByIdentity.contains(vertex);
    }

    private boolean containsVertexName(Vertex vertex) {
        return this.nameToVertex.containsKey(vertex.getName());
    }

    Iterable<Vertex> validate() {
        Preconditions.checkTrue((!this.nameToVertex.isEmpty() ? 1 : 0) != 0, (String)"DAG must contain at least one vertex");
        Map<String, List<Edge>> inboundEdgeMap = this.edges.stream().collect(Collectors.groupingBy(Edge::getDestName));
        Map<String, List<Edge>> outboundEdgeMap = this.edges.stream().collect(Collectors.groupingBy(Edge::getSourceName));
        DAG.validateInboundEdgeOrdinals(inboundEdgeMap);
        DAG.validateOutboundEdgeOrdinals(outboundEdgeMap);
        HashMap<Vertex, List> adjacencyMap = new HashMap<Vertex, List>();
        for (Edge edge : this.edges) {
            adjacencyMap.computeIfAbsent(edge.getSource(), x -> new ArrayList()).add(edge.getDestination());
        }
        for (Vertex v : this.nameToVertex.values()) {
            adjacencyMap.computeIfAbsent(v, x -> Collections.emptyList());
        }
        return TopologicalSorter.topologicalSort(adjacencyMap, Vertex::getName);
    }

    private static void validateInboundEdgeOrdinals(Map<String, List<Edge>> inboundEdgeMap) {
        for (Map.Entry<String, List<Edge>> entry : inboundEdgeMap.entrySet()) {
            String vertex = entry.getKey();
            int[] ordinals = entry.getValue().stream().mapToInt(Edge::getDestOrdinal).sorted().toArray();
            for (int i = 0; i < ordinals.length; ++i) {
                if (ordinals[i] == i) continue;
                throw new IllegalArgumentException("Input ordinals for vertex " + vertex + " are not properly numbered. Actual: " + Arrays.toString(ordinals) + " Expected: " + Arrays.toString(IntStream.range(0, ordinals.length).toArray()));
            }
        }
    }

    private static void validateOutboundEdgeOrdinals(Map<String, List<Edge>> outboundEdgeMap) {
        for (Map.Entry<String, List<Edge>> entry : outboundEdgeMap.entrySet()) {
            String vertex = entry.getKey();
            int[] ordinals = entry.getValue().stream().mapToInt(Edge::getSourceOrdinal).sorted().toArray();
            for (int i = 0; i < ordinals.length; ++i) {
                if (ordinals[i] == i) continue;
                throw new IllegalArgumentException("Output ordinals for vertex " + vertex + " are not ordered. Actual: " + Arrays.toString(ordinals) + " Expected: " + Arrays.toString(IntStream.range(0, ordinals.length).toArray()));
            }
        }
    }

    public String toString() {
        return this.toString(-1);
    }

    public String toString(int defaultLocalParallelism) {
        StringBuilder b = new StringBuilder("dag\n");
        for (Vertex v : this) {
            b.append("    .vertex(\"").append(v.getName()).append("\")");
            int localParallelism = v.getLocalParallelism();
            if (localParallelism == -1 && (localParallelism = v.getMetaSupplier().preferredLocalParallelism()) == -1) {
                localParallelism = defaultLocalParallelism;
            }
            if (localParallelism != -1) {
                b.append(".localParallelism(").append(localParallelism).append(')');
            }
            b.append('\n');
        }
        for (Edge e : this.edges) {
            b.append("    .edge(").append(e).append(")\n");
        }
        return b.toString();
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.nameToVertex.size());
        for (Map.Entry<String, Vertex> entry : this.nameToVertex.entrySet()) {
            out.writeObject((Object)entry.getKey());
            out.writeObject((Object)entry.getValue());
        }
        out.writeInt(this.edges.size());
        for (Edge edge : this.edges) {
            out.writeObject((Object)edge);
        }
    }

    public void readData(ObjectDataInput in) throws IOException {
        int vertexCount = in.readInt();
        for (int i = 0; i < vertexCount; ++i) {
            String key = (String)in.readObject();
            Vertex value = (Vertex)in.readObject();
            this.nameToVertex.put(key, value);
        }
        int edgeCount = in.readInt();
        for (int i = 0; i < edgeCount; ++i) {
            Edge edge = (Edge)in.readObject();
            edge.restoreSourceAndDest(this.nameToVertex);
            this.edges.add(edge);
        }
        this.verticesByIdentity.addAll(this.nameToVertex.values());
    }

    public int getFactoryId() {
        return SerializationConstants.FACTORY_ID;
    }

    public int getId() {
        return 0;
    }
}

