/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.util.Preconditions;
import javax.annotation.Nonnull;

public class InstanceConfig {
    public static final int DEFAULT_FLOW_CONTROL_PERIOD_MS = 100;
    public static final int DEFAULT_BACKUP_COUNT = 1;
    private int cooperativeThreadCount = Runtime.getRuntime().availableProcessors();
    private int flowControlPeriodMs = 100;
    private int backupCount = 1;
    private String tempDir;

    public InstanceConfig setCooperativeThreadCount(int size) {
        Preconditions.checkPositive((int)size, (String)"cooperativeThreadCount should be a positive number");
        this.cooperativeThreadCount = size;
        return this;
    }

    public int getCooperativeThreadCount() {
        return this.cooperativeThreadCount;
    }

    public InstanceConfig setTempDir(String tempDir) {
        this.tempDir = tempDir;
        return this;
    }

    @Nonnull
    public String getTempDir() {
        return this.tempDir == null ? System.getProperty("java.io.tmpdir") : this.tempDir;
    }

    public InstanceConfig setFlowControlPeriodMs(int flowControlPeriodMs) {
        Preconditions.checkPositive((int)flowControlPeriodMs, (String)"flowControlPeriodMs should be a positive number");
        this.flowControlPeriodMs = flowControlPeriodMs;
        return this;
    }

    public int getFlowControlPeriodMs() {
        return this.flowControlPeriodMs;
    }

    public InstanceConfig setBackupCount(int newBackupCount) {
        Preconditions.checkBackupCount((int)newBackupCount, (int)0);
        this.backupCount = newBackupCount;
        return this;
    }

    public int getBackupCount() {
        return this.backupCount;
    }
}

