/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.aggregate;

import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.datamodel.ItemsByTag;
import com.hazelcast.jet.datamodel.Tag;
import com.hazelcast.jet.function.DistributedFunction;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public final class AllOfAggregationBuilder<T> {
    private List<Tag> tags = new ArrayList<Tag>();
    private List<AggregateOperation1> operations = new ArrayList<AggregateOperation1>();

    AllOfAggregationBuilder() {
    }

    @Nonnull
    public <R> Tag<R> add(@Nonnull AggregateOperation1<? super T, ?, R> operation) {
        this.operations.add(operation);
        Tag tag = Tag.tag(this.tags.size());
        this.tags.add(tag);
        return tag;
    }

    @Nonnull
    public AggregateOperation1<T, Object[], ItemsByTag> build() {
        return this.build(DistributedFunction.identity());
    }

    @Nonnull
    public <R> AggregateOperation1<T, Object[], R> build(@Nonnull DistributedFunction<ItemsByTag, R> finishFn) {
        return AggregateOperation.withCreate(() -> {
            Object[] acc = new Object[this.tags.size()];
            for (int i = 0; i < acc.length; ++i) {
                acc[i] = this.operations.get(i).createFn().get();
            }
            return acc;
        }).andAccumulate((acc, item) -> {
            for (int i = 0; i < ((Object[])acc).length; ++i) {
                this.operations.get(i).accumulateFn().accept(acc[i], item);
            }
        }).andCombine(this.operations.stream().anyMatch(o -> o.combineFn() == null) ? null : (acc1, acc2) -> {
            for (int i = 0; i < ((Object[])acc1).length; ++i) {
                this.operations.get(i).combineFn().accept(acc1[i], acc2[i]);
            }
        }).andDeduct(this.operations.stream().anyMatch(o -> o.deductFn() == null) ? null : (acc1, acc2) -> {
            for (int i = 0; i < ((Object[])acc1).length; ++i) {
                this.operations.get(i).deductFn().accept(acc1[i], acc2[i]);
            }
        }).andFinish(acc -> {
            ItemsByTag result = new ItemsByTag();
            for (int i = 0; i < this.tags.size(); ++i) {
                Object finishedVal = this.operations.get(i).finishFn().apply(acc[i]);
                result.put(this.tags.get(i), finishedVal);
            }
            return finishFn.apply(result);
        });
    }
}

