/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.aggregate;

import com.hazelcast.jet.accumulator.DoubleAccumulator;
import com.hazelcast.jet.accumulator.LinTrendAccumulator;
import com.hazelcast.jet.accumulator.LongAccumulator;
import com.hazelcast.jet.accumulator.LongDoubleAccumulator;
import com.hazelcast.jet.accumulator.LongLongAccumulator;
import com.hazelcast.jet.accumulator.MutableReference;
import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.aggregate.AggregateOperation2;
import com.hazelcast.jet.aggregate.AggregateOperation3;
import com.hazelcast.jet.aggregate.AggregateOperationBuilder;
import com.hazelcast.jet.aggregate.AllOfAggregationBuilder;
import com.hazelcast.jet.datamodel.BagsByTag;
import com.hazelcast.jet.datamodel.Tag;
import com.hazelcast.jet.datamodel.ThreeBags;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.datamodel.Tuple3;
import com.hazelcast.jet.datamodel.TwoBags;
import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedBiFunction;
import com.hazelcast.jet.function.DistributedBinaryOperator;
import com.hazelcast.jet.function.DistributedComparator;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.function.DistributedToDoubleFunction;
import com.hazelcast.jet.function.DistributedToLongFunction;
import com.hazelcast.jet.function.DistributedTriFunction;
import com.hazelcast.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class AggregateOperations {
    private AggregateOperations() {
    }

    @Nonnull
    public static <T> AggregateOperation1<T, LongAccumulator, Long> counting() {
        return AggregateOperation.withCreate(LongAccumulator::new).andAccumulate((a, item) -> a.add(1L)).andCombine(LongAccumulator::add).andDeduct(LongAccumulator::subtractAllowingOverflow).andFinish(LongAccumulator::get);
    }

    @Nonnull
    public static <T> AggregateOperation1<T, LongAccumulator, Long> summingLong(@Nonnull DistributedToLongFunction<? super T> getLongValueFn) {
        return AggregateOperation.withCreate(LongAccumulator::new).andAccumulate((a, item) -> a.add(getLongValueFn.applyAsLong(item))).andCombine(LongAccumulator::add).andDeduct(LongAccumulator::subtract).andFinish(LongAccumulator::get);
    }

    @Nonnull
    public static <T> AggregateOperation1<T, DoubleAccumulator, Double> summingDouble(@Nonnull DistributedToDoubleFunction<? super T> getDoubleValueFn) {
        return AggregateOperation.withCreate(DoubleAccumulator::new).andAccumulate((a, item) -> a.accumulate(getDoubleValueFn.applyAsDouble(item))).andCombine(DoubleAccumulator::combine).andDeduct(DoubleAccumulator::deduct).andFinish(DoubleAccumulator::finish);
    }

    @Nonnull
    public static <T> AggregateOperation1<T, MutableReference<T>, T> minBy(@Nonnull DistributedComparator<? super T> comparator) {
        return AggregateOperations.maxBy(comparator.reversed());
    }

    @Nonnull
    public static <T> AggregateOperation1<T, MutableReference<T>, T> maxBy(@Nonnull DistributedComparator<? super T> comparator) {
        return AggregateOperation.withCreate(MutableReference::new).andAccumulate((a, i) -> {
            if (!a.isPresent() || comparator.compare(i, a.get()) > 0) {
                a.set(i);
            }
        }).andCombine((a1, a2) -> {
            if (!a1.isPresent() || comparator.compare((Object)a1.get(), (Object)a2.get()) < 0) {
                a1.set(a2.get());
            }
        }).andFinish(MutableReference::get);
    }

    @Nonnull
    public static <T> AggregateOperation1<T, LongLongAccumulator, Double> averagingLong(@Nonnull DistributedToLongFunction<? super T> getLongValueFn) {
        return AggregateOperation.withCreate(LongLongAccumulator::new).andAccumulate((a, i) -> {
            if (a.get1() == Long.MAX_VALUE) {
                throw new ArithmeticException("Counter overflow");
            }
            a.set1(a.get1() + 1L);
            a.set2(Math.addExact(a.get2(), getLongValueFn.applyAsLong(i)));
        }).andCombine((a1, a2) -> {
            a1.set1(Math.addExact(a1.get1(), a2.get1()));
            a1.set2(Math.addExact(a1.get2(), a2.get2()));
        }).andDeduct((a1, a2) -> {
            a1.set1(Math.subtractExact(a1.get1(), a2.get1()));
            a1.set2(Math.subtractExact(a1.get2(), a2.get2()));
        }).andFinish(a -> (double)a.get2() / (double)a.get1());
    }

    @Nonnull
    public static <T> AggregateOperation1<T, LongDoubleAccumulator, Double> averagingDouble(@Nonnull DistributedToDoubleFunction<? super T> getDoubleValueFn) {
        return AggregateOperation.withCreate(LongDoubleAccumulator::new).andAccumulate((a, item) -> {
            if (a.getLong() == Long.MAX_VALUE) {
                throw new ArithmeticException("Counter overflow");
            }
            a.setLong(a.getLong() + 1L);
            a.setDouble(a.getDouble() + getDoubleValueFn.applyAsDouble(item));
        }).andCombine((a1, a2) -> {
            a1.setLong(Math.addExact(a1.getLong(), a2.getLong()));
            a1.setDouble(a1.getDouble() + a2.getDouble());
        }).andDeduct((a1, a2) -> {
            a1.setLong(Math.subtractExact(a1.getLong(), a2.getLong()));
            a1.setDouble(a1.getDouble() - a2.getDouble());
        }).andFinish(a -> a.getDouble() / (double)a.getLong());
    }

    @Nonnull
    public static <T> AggregateOperation1<T, LinTrendAccumulator, Double> linearTrend(@Nonnull DistributedToLongFunction<T> getXFn, @Nonnull DistributedToLongFunction<T> getYFn) {
        return AggregateOperation.withCreate(LinTrendAccumulator::new).andAccumulate((a, item) -> a.accumulate(getXFn.applyAsLong(item), getYFn.applyAsLong(item))).andCombine(LinTrendAccumulator::combine).andDeduct(LinTrendAccumulator::deduct).andFinish(LinTrendAccumulator::finish);
    }

    @Nonnull
    public static <T, A1, A2, R1, R2> AggregateOperation1<T, Tuple2<A1, A2>, Tuple2<R1, R2>> allOf(@Nonnull AggregateOperation1<? super T, A1, R1> op1, @Nonnull AggregateOperation1<? super T, A2, R2> op2) {
        return AggregateOperations.allOf(op1, op2, Tuple2::tuple2);
    }

    @Nonnull
    public static <T, A1, A2, R1, R2, R> AggregateOperation1<T, Tuple2<A1, A2>, R> allOf(@Nonnull AggregateOperation1<? super T, A1, R1> op1, @Nonnull AggregateOperation1<? super T, A2, R2> op2, @Nonnull DistributedBiFunction<? super R1, ? super R2, R> finishFn) {
        return AggregateOperation.withCreate(() -> Tuple2.tuple2(op1.createFn().get(), op2.createFn().get())).andAccumulate((acc, item) -> {
            op1.accumulateFn().accept(acc.f0(), item);
            op2.accumulateFn().accept(acc.f1(), item);
        }).andCombine(op1.combineFn() == null || op2.combineFn() == null ? null : (acc1, acc2) -> {
            op1.combineFn().accept(acc1.f0(), acc2.f0());
            op2.combineFn().accept(acc1.f1(), acc2.f1());
        }).andDeduct(op1.deductFn() == null || op2.deductFn() == null ? null : (acc1, acc2) -> {
            op1.deductFn().accept(acc1.f0(), acc2.f0());
            op2.deductFn().accept(acc1.f1(), acc2.f1());
        }).andFinish(acc -> finishFn.apply((Object)op1.finishFn().apply(acc.f0()), (Object)op2.finishFn().apply(acc.f1())));
    }

    @Nonnull
    public static <T, A1, A2, A3, R1, R2, R3> AggregateOperation1<T, Tuple3<A1, A2, A3>, Tuple3<R1, R2, R3>> allOf(@Nonnull AggregateOperation1<? super T, A1, R1> op1, @Nonnull AggregateOperation1<? super T, A2, R2> op2, @Nonnull AggregateOperation1<? super T, A3, R3> op3) {
        return AggregateOperations.allOf(op1, op2, op3, Tuple3::tuple3);
    }

    @Nonnull
    public static <T, A1, A2, A3, R1, R2, R3, R> AggregateOperation1<T, Tuple3<A1, A2, A3>, R> allOf(@Nonnull AggregateOperation1<? super T, A1, R1> op1, @Nonnull AggregateOperation1<? super T, A2, R2> op2, @Nonnull AggregateOperation1<? super T, A3, R3> op3, @Nonnull DistributedTriFunction<? super R1, ? super R2, ? super R3, R> finishFn) {
        return AggregateOperation.withCreate(() -> Tuple3.tuple3(op1.createFn().get(), op2.createFn().get(), op3.createFn().get())).andAccumulate((acc, item) -> {
            op1.accumulateFn().accept(acc.f0(), item);
            op2.accumulateFn().accept(acc.f1(), item);
            op3.accumulateFn().accept(acc.f2(), item);
        }).andCombine(op1.combineFn() == null || op2.combineFn() == null ? null : (acc1, acc2) -> {
            op1.combineFn().accept(acc1.f0(), acc2.f0());
            op2.combineFn().accept(acc1.f1(), acc2.f1());
            op3.combineFn().accept(acc1.f2(), acc2.f2());
        }).andDeduct(op1.deductFn() == null || op2.deductFn() == null ? null : (acc1, acc2) -> {
            op1.deductFn().accept(acc1.f0(), acc2.f0());
            op2.deductFn().accept(acc1.f1(), acc2.f1());
            op3.deductFn().accept(acc1.f2(), acc2.f2());
        }).andFinish(acc -> finishFn.apply((Object)op1.finishFn().apply(acc.f0()), (Object)op2.finishFn().apply(acc.f1()), (Object)op3.finishFn().apply(acc.f2())));
    }

    @Nonnull
    public static <T> AllOfAggregationBuilder<T> allOfBuilder() {
        return new AllOfAggregationBuilder();
    }

    public static AggregateOperation1<CharSequence, StringBuilder, String> concatenating() {
        return AggregateOperation.withCreate(StringBuilder::new).andAccumulate(StringBuilder::append).andCombine(StringBuilder::append).andFinish(StringBuilder::toString);
    }

    public static AggregateOperation1<CharSequence, StringBuilder, String> concatenating(CharSequence delimiter) {
        return AggregateOperations.concatenating(delimiter, "", "");
    }

    public static AggregateOperation1<CharSequence, StringBuilder, String> concatenating(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        int prefixLen = prefix.length();
        return AggregateOperation.withCreate(() -> new StringBuilder().append(prefix)).andAccumulate((builder, val) -> {
            if (builder.length() != prefixLen && val.length() > 0) {
                builder.append(delimiter);
            }
            builder.append((CharSequence)val);
        }).andCombine((l, r) -> {
            if (l.length() != prefixLen && r.length() != prefixLen) {
                l.append(delimiter);
            }
            l.append((CharSequence)r, prefixLen, r.length());
        }).andFinish(r -> r.append(suffix).toString());
    }

    public static <T, U, A, R> AggregateOperation1<T, A, R> mapping(@Nonnull DistributedFunction<? super T, ? extends U> mapFn, @Nonnull AggregateOperation1<? super U, A, R> downstream) {
        DistributedBiConsumer downstreamAccumulateFn = downstream.accumulateFn();
        return AggregateOperation.withCreate(downstream.createFn()).andAccumulate((a, t) -> {
            Object mapped = mapFn.apply(t);
            if (mapped != null) {
                downstreamAccumulateFn.accept((Object)a, (Object)mapped);
            }
        }).andCombine(downstream.combineFn()).andDeduct(downstream.deductFn()).andFinish(downstream.finishFn());
    }

    public static <T, C extends Collection<T>> AggregateOperation1<T, C, C> toCollection(DistributedSupplier<C> createCollectionFn) {
        return AggregateOperation.withCreate(createCollectionFn).andAccumulate(Collection::add).andCombine(Collection::addAll).andIdentityFinish();
    }

    public static <T> AggregateOperation1<T, List<T>, List<T>> toList() {
        return AggregateOperations.toCollection(ArrayList::new);
    }

    public static <T> AggregateOperation1<T, Set<T>, Set<T>> toSet() {
        return AggregateOperations.toCollection(HashSet::new);
    }

    public static <T, K, U> AggregateOperation1<T, Map<K, U>, Map<K, U>> toMap(DistributedFunction<? super T, ? extends K> toKeyFn, DistributedFunction<? super T, ? extends U> toValueFn) {
        return AggregateOperations.toMap(toKeyFn, toValueFn, (k, v) -> {
            throw new IllegalStateException("Duplicate key: " + k);
        }, HashMap::new);
    }

    public static <T, K, U> AggregateOperation1<T, Map<K, U>, Map<K, U>> toMap(DistributedFunction<? super T, ? extends K> toKeyFn, DistributedFunction<? super T, ? extends U> toValueFn, DistributedBinaryOperator<U> mergeFn) {
        return AggregateOperations.toMap(toKeyFn, toValueFn, mergeFn, HashMap::new);
    }

    public static <T, K, U, M extends Map<K, U>> AggregateOperation1<T, M, M> toMap(DistributedFunction<? super T, ? extends K> toKeyFn, DistributedFunction<? super T, ? extends U> toValueFn, DistributedBinaryOperator<U> mergeFn, DistributedSupplier<M> createMapFn) {
        DistributedBiConsumer accumulateFn = (map, element) -> map.merge(toKeyFn.apply(element), toValueFn.apply(element), mergeFn);
        return AggregateOperation.withCreate(createMapFn).andAccumulate(accumulateFn).andCombine((l, r) -> r.forEach((key, value) -> l.merge(key, value, mergeFn))).andIdentityFinish();
    }

    @Nonnull
    public static <T0, T1> AggregateOperation2<T0, T1, TwoBags<T0, T1>, TwoBags<T0, T1>> toTwoBags() {
        return AggregateOperation.withCreate(TwoBags::twoBags).andAccumulate0((acc, item0) -> acc.bag0().add(item0)).andAccumulate1((acc, item1) -> acc.bag1().add(item1)).andCombine(TwoBags::combineWith).andDeduct(TwoBags::deduct).andFinish(TwoBags::finish);
    }

    @Nonnull
    public static <T0, T1, T2> AggregateOperation3<T0, T1, T2, ThreeBags<T0, T1, T2>, ThreeBags<T0, T1, T2>> toThreeBags() {
        return AggregateOperation.withCreate(ThreeBags::threeBags).andAccumulate0((acc, item0) -> acc.bag0().add(item0)).andAccumulate1((acc, item1) -> acc.bag1().add(item1)).andAccumulate2((acc, item2) -> acc.bag2().add(item2)).andCombine(ThreeBags::combineWith).andDeduct(ThreeBags::deduct).andFinish(ThreeBags::finish);
    }

    @Nonnull
    public static AggregateOperation<BagsByTag, BagsByTag> toBagsByTag(Tag<?> ... tags) {
        Preconditions.checkPositive((int)tags.length, (String)"At least one tag required");
        AggregateOperationBuilder.VarArity builder = AggregateOperation.withCreate(BagsByTag::new).andAccumulate(tags[0], (acc, item) -> acc.ensureBag(tags[0]).add(item));
        for (int i = 1; i < tags.length; ++i) {
            Tag<?> tag = tags[i];
            builder = builder.andAccumulate(tag, (acc, item) -> acc.ensureBag(tag).add(item));
        }
        return builder.andCombine(BagsByTag::combineWith).andFinish(BagsByTag::finish);
    }

    public static <T, K> AggregateOperation1<T, Map<K, List<T>>, Map<K, List<T>>> groupingBy(DistributedFunction<? super T, ? extends K> toKeyFn) {
        return AggregateOperations.groupingBy(toKeyFn, AggregateOperations.toList());
    }

    public static <T, K, A, R> AggregateOperation1<T, Map<K, A>, Map<K, R>> groupingBy(DistributedFunction<? super T, ? extends K> toKeyFn, AggregateOperation1<? super T, A, R> downstream) {
        return AggregateOperations.groupingBy(toKeyFn, HashMap::new, downstream);
    }

    public static <T, K, R, A, M extends Map<K, R>> AggregateOperation1<T, Map<K, A>, M> groupingBy(DistributedFunction<? super T, ? extends K> toKeyFn, DistributedSupplier<M> createMapFn, AggregateOperation1<? super T, A, R> downstream) {
        DistributedBiConsumer accumulateFn = (m, t) -> {
            Object acc = m.computeIfAbsent(toKeyFn.apply(t), k -> downstream.createFn().get());
            downstream.accumulateFn().accept(acc, t);
        };
        DistributedBiConsumer combineFn = (l, r) -> r.forEach((key, value) -> l.merge(key, value, (a, b) -> {
            downstream.combineFn().accept(a, b);
            return a;
        }));
        DistributedSupplier<M> createAccMapFn = createMapFn;
        DistributedFunction downstreamFinishFn = downstream.finishFn();
        DistributedFunction finisher = accMap -> {
            accMap.replaceAll((k, v) -> downstreamFinishFn.apply(v));
            return accMap;
        };
        return AggregateOperation.withCreate(createAccMapFn).andAccumulate(accumulateFn).andCombine(combineFn).andFinish(finisher);
    }

    @Nonnull
    public static <T, A> AggregateOperation1<T, MutableReference<A>, A> reducing(@Nonnull A emptyAccValue, @Nonnull DistributedFunction<? super T, ? extends A> toAccValueFn, @Nonnull DistributedBinaryOperator<A> combineAccValuesFn, @Nullable DistributedBinaryOperator<A> deductAccValueFn) {
        DistributedBinaryOperator deductFn = deductAccValueFn;
        return AggregateOperation.withCreate(() -> new MutableReference<Object>(emptyAccValue)).andAccumulate((a, t) -> a.set(combineAccValuesFn.apply(a.get(), toAccValueFn.apply(t)))).andCombine((a, b) -> a.set(combineAccValuesFn.apply(a.get(), b.get()))).andDeduct(deductAccValueFn != null ? (a, b) -> a.set(deductFn.apply(a.get(), b.get())) : null).andFinish(MutableReference::get);
    }
}

