/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.accumulator;

import com.hazelcast.jet.accumulator.DoubleAccumulator;
import com.hazelcast.jet.accumulator.LinTrendAccumulator;
import com.hazelcast.jet.accumulator.LongAccumulator;
import com.hazelcast.jet.accumulator.LongDoubleAccumulator;
import com.hazelcast.jet.accumulator.LongLongAccumulator;
import com.hazelcast.jet.accumulator.MutableReference;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.math.BigInteger;

class AccumulatorSerializerHooks {
    AccumulatorSerializerHooks() {
    }

    public static final class LongDoubleAccHook
    implements SerializerHook<LongDoubleAccumulator> {
        public Class<LongDoubleAccumulator> getSerializationType() {
            return LongDoubleAccumulator.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<LongDoubleAccumulator>(){

                public int getTypeId() {
                    return -309;
                }

                public void destroy() {
                }

                public void write(ObjectDataOutput out, LongDoubleAccumulator object) throws IOException {
                    out.writeLong(object.getLong());
                    out.writeDouble(object.getDouble());
                }

                public LongDoubleAccumulator read(ObjectDataInput in) throws IOException {
                    return new LongDoubleAccumulator(in.readLong(), in.readDouble());
                }
            };
        }

        public boolean isOverwritable() {
            return true;
        }
    }

    public static final class LongLongAccHook
    implements SerializerHook<LongLongAccumulator> {
        public Class<LongLongAccumulator> getSerializationType() {
            return LongLongAccumulator.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<LongLongAccumulator>(){

                public int getTypeId() {
                    return -308;
                }

                public void destroy() {
                }

                public void write(ObjectDataOutput out, LongLongAccumulator object) throws IOException {
                    out.writeLong(object.get1());
                    out.writeLong(object.get2());
                }

                public LongLongAccumulator read(ObjectDataInput in) throws IOException {
                    return new LongLongAccumulator(in.readLong(), in.readLong());
                }
            };
        }

        public boolean isOverwritable() {
            return true;
        }
    }

    public static final class LinTrendAccHook
    implements SerializerHook<LinTrendAccumulator> {
        public Class<LinTrendAccumulator> getSerializationType() {
            return LinTrendAccumulator.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<LinTrendAccumulator>(){

                public int getTypeId() {
                    return -307;
                }

                public void destroy() {
                }

                public void write(ObjectDataOutput out, LinTrendAccumulator object) throws IOException {
                    object.writeObject(out);
                }

                public LinTrendAccumulator read(ObjectDataInput in) throws IOException {
                    return new LinTrendAccumulator(in.readLong(), this.readBigInt(in), this.readBigInt(in), this.readBigInt(in), this.readBigInt(in));
                }

                private BigInteger readBigInt(ObjectDataInput in) throws IOException {
                    byte[] bytes = new byte[in.readUnsignedByte()];
                    for (int i = 0; i < bytes.length; ++i) {
                        bytes[i] = in.readByte();
                    }
                    return new BigInteger(bytes);
                }
            };
        }

        public boolean isOverwritable() {
            return true;
        }
    }

    public static final class MutableReferenceHook
    implements SerializerHook<MutableReference> {
        public Class<MutableReference> getSerializationType() {
            return MutableReference.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<MutableReference>(){

                public int getTypeId() {
                    return -306;
                }

                public void destroy() {
                }

                public void write(ObjectDataOutput out, MutableReference object) throws IOException {
                    out.writeObject(object.get());
                }

                public MutableReference read(ObjectDataInput in) throws IOException {
                    return new MutableReference<Object>(in.readObject());
                }
            };
        }

        public boolean isOverwritable() {
            return true;
        }
    }

    public static final class DoubleAccHook
    implements SerializerHook<DoubleAccumulator> {
        public Class<DoubleAccumulator> getSerializationType() {
            return DoubleAccumulator.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<DoubleAccumulator>(){

                public int getTypeId() {
                    return -305;
                }

                public void destroy() {
                }

                public void write(ObjectDataOutput out, DoubleAccumulator object) throws IOException {
                    out.writeDouble(object.finish());
                }

                public DoubleAccumulator read(ObjectDataInput in) throws IOException {
                    return new DoubleAccumulator(in.readDouble());
                }
            };
        }

        public boolean isOverwritable() {
            return true;
        }
    }

    public static final class LongAccHook
    implements SerializerHook<LongAccumulator> {
        public Class<LongAccumulator> getSerializationType() {
            return LongAccumulator.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<LongAccumulator>(){

                public int getTypeId() {
                    return -304;
                }

                public void destroy() {
                }

                public void write(ObjectDataOutput out, LongAccumulator object) throws IOException {
                    out.writeLong(object.get());
                }

                public LongAccumulator read(ObjectDataInput in) throws IOException {
                    return new LongAccumulator(in.readLong());
                }
            };
        }

        public boolean isOverwritable() {
            return true;
        }
    }
}

