/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream;

import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedBinaryOperator;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.stream.DistributedCollectors;
import com.hazelcast.jet.stream.impl.pipeline.Pipe;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import com.hazelcast.jet.stream.impl.reducers.DistributedCollectorImpl;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collector;

public interface DistributedCollector<T, A, R>
extends Collector<T, A, R>,
Serializable {
    @Override
    public DistributedSupplier<A> supplier();

    @Override
    public DistributedBiConsumer<A, T> accumulator();

    @Override
    public DistributedBinaryOperator<A> combiner();

    @Override
    public DistributedFunction<A, R> finisher();

    public static <T, R> DistributedCollector<T, R, R> of(DistributedSupplier<R> supplier, DistributedBiConsumer<R, T> accumulator, DistributedBinaryOperator<R> combiner, Collector.Characteristics ... characteristics) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(accumulator);
        Objects.requireNonNull(combiner);
        Objects.requireNonNull(characteristics);
        Set<Collector.Characteristics> cs = characteristics.length == 0 ? DistributedCollectors.CH_ID : Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH, characteristics));
        return new DistributedCollectorImpl(supplier, accumulator, combiner, cs);
    }

    public static <T, A, R> DistributedCollector<T, A, R> of(DistributedSupplier<A> supplier, DistributedBiConsumer<A, T> accumulator, DistributedBinaryOperator<A> combiner, DistributedFunction<A, R> finisher, Collector.Characteristics ... characteristics) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(accumulator);
        Objects.requireNonNull(combiner);
        Objects.requireNonNull(finisher);
        Objects.requireNonNull(characteristics);
        Set<Collector.Characteristics> cs = DistributedCollectors.CH_NOID;
        if (characteristics.length > 0) {
            cs = EnumSet.noneOf(Collector.Characteristics.class);
            Collections.addAll(cs, characteristics);
            cs = Collections.unmodifiableSet(cs);
        }
        return new DistributedCollectorImpl<T, A, R>(supplier, accumulator, combiner, finisher, cs);
    }

    public static interface Reducer<T, R>
    extends Serializable {
        public R reduce(StreamContext var1, Pipe<? extends T> var2);
    }
}

