/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.client.impl.protocol.ClientExceptionFactory;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.core.TopologyChangedException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.exception.CallerNotMemberException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static boolean isTopologicalFailure(Object t) {
        return t instanceof TopologyChangedException || t instanceof MemberLeftException || t instanceof TargetNotMemberException || t instanceof CallerNotMemberException || t instanceof HazelcastInstanceNotActiveException;
    }

    public static void registerJetExceptions(@Nonnull ClientExceptionFactory factory) {
        factory.register(500, JetException.class, JetException::new);
        factory.register(501, TopologyChangedException.class, TopologyChangedException::new);
    }

    public static Throwable peel(@Nullable Throwable t) {
        Throwable peeled = t;
        while ((peeled instanceof CompletionException || peeled instanceof ExecutionException || peeled instanceof InvocationTargetException) && peeled.getCause() != null) {
            peeled = t.getCause();
        }
        return peeled;
    }

    @Nonnull
    private static RuntimeException peeledAndUnchecked(@Nonnull Throwable t) {
        if ((t = ExceptionUtil.peel(t)) instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new JetException(t);
    }

    @Nonnull
    public static RuntimeException rethrow(@Nonnull Throwable t) {
        if (t instanceof Error) {
            if (t instanceof OutOfMemoryError) {
                OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)((OutOfMemoryError)t));
            }
            throw (Error)t;
        }
        throw ExceptionUtil.peeledAndUnchecked(t);
    }

    @Nonnull
    public static <T> BiConsumer<T, ? super Throwable> withTryCatch(@Nonnull ILogger logger, @Nonnull BiConsumer<T, ? super Throwable> consumer) {
        return ExceptionUtil.withTryCatch(logger, "Exception during callback", consumer);
    }

    @Nonnull
    public static <T> BiConsumer<T, ? super Throwable> withTryCatch(@Nonnull ILogger logger, @Nonnull String message, @Nonnull BiConsumer<T, ? super Throwable> consumer) {
        return (r, t) -> {
            try {
                consumer.accept((Object)r, (Throwable)t);
            }
            catch (Throwable e) {
                logger.severe(message, e);
            }
        };
    }

    @Nonnull
    public static <T extends Throwable> RuntimeException sneakyThrow(@Nonnull Throwable t) throws T {
        throw t;
    }
}

