/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.serialization;

import com.hazelcast.jet.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.util.Map;

public final class MapEntryHook
implements SerializerHook<Map.Entry> {
    public Class<Map.Entry> getSerializationType() {
        return Map.Entry.class;
    }

    public Serializer createSerializer() {
        return new StreamSerializer<Map.Entry>(){

            public int getTypeId() {
                return -300;
            }

            public void write(ObjectDataOutput out, Map.Entry object) throws IOException {
                out.writeObject(object.getKey());
                out.writeObject(object.getValue());
            }

            public Map.Entry read(ObjectDataInput in) throws IOException {
                return Util.entry(in.readObject(), in.readObject());
            }

            public void destroy() {
            }
        };
    }

    public boolean isOverwritable() {
        return true;
    }
}

