/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.core.PartitionAware;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import javax.annotation.Nonnull;

public final class SnapshotKey
implements PartitionAware<Object>,
IdentifiedDataSerializable {
    long timestamp;
    Object key;

    public SnapshotKey() {
    }

    SnapshotKey(long timestamp, @Nonnull Object key) {
        this.timestamp = timestamp;
        this.key = key;
    }

    public Object getPartitionKey() {
        return this.key;
    }

    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    public int getId() {
        return 15;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.timestamp);
        out.writeObject(this.key);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.timestamp = in.readLong();
        this.key = in.readObject();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof SnapshotKey)) return false;
        SnapshotKey that = (SnapshotKey)o;
        if (this.timestamp != that.timestamp) return false;
        if (!this.key.equals(that.key)) return false;
        return true;
    }

    public int hashCode() {
        int hc = (int)(this.timestamp ^ this.timestamp >>> 32);
        hc = 73 * hc + this.key.hashCode();
        return hc;
    }

    public String toString() {
        return "SnapshotKey{timestamp=" + this.timestamp + ", key=" + this.key + '}';
    }
}

