/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.operation.AsyncExecutionOperation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public class JoinSubmittedJobOperation
extends AsyncExecutionOperation
implements IdentifiedDataSerializable {
    private volatile CompletableFuture<Boolean> executionFuture;

    public JoinSubmittedJobOperation() {
    }

    public JoinSubmittedJobOperation(long jobId) {
        super(jobId);
    }

    @Override
    protected void doRun() {
        JetService service = (JetService)this.getService();
        this.executionFuture = service.joinSubmittedJob(this.jobId);
        this.executionFuture.whenComplete((BiConsumer)ExceptionUtil.withTryCatch(this.getLogger(), (r, t) -> this.doSendResponse(ExceptionUtil.peel(t))));
    }

    @Override
    public void cancel() {
        if (this.executionFuture != null) {
            this.executionFuture.cancel(true);
        }
    }

    public int getId() {
        return 17;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
    }
}

