/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.jet.impl.execution.init.ExecutionPlan;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;

public class InitOperation
extends Operation
implements IdentifiedDataSerializable {
    private long jobId;
    private long executionId;
    private int coordinatorMemberListVersion;
    private Set<MemberInfo> participants;
    private Supplier<ExecutionPlan> planSupplier;

    public InitOperation() {
    }

    public InitOperation(long jobId, long executionId, int coordinatorMemberListVersion, Set<MemberInfo> participants, ExecutionPlan plan) {
        this.jobId = jobId;
        this.executionId = executionId;
        this.coordinatorMemberListVersion = coordinatorMemberListVersion;
        this.participants = participants;
        this.executionId = executionId;
        this.planSupplier = () -> plan;
    }

    public void run() throws Exception {
        ILogger logger = this.getLogger();
        JetService service = (JetService)this.getService();
        Address caller = this.getCallerAddress();
        logger.fine("Initializing execution plan for " + Util.jobAndExecutionId(this.jobId, this.executionId) + " from " + caller);
        ExecutionPlan plan = this.planSupplier.get();
        service.initExecution(this.jobId, this.executionId, caller, this.coordinatorMemberListVersion, this.participants, plan);
    }

    public ExceptionAction onInvocationException(Throwable throwable) {
        return ExceptionUtil.isTopologicalFailure(throwable) ? ExceptionAction.THROW_EXCEPTION : super.onInvocationException(throwable);
    }

    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    public int getId() {
        return 5;
    }

    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.jobId);
        out.writeLong(this.executionId);
        out.writeInt(this.coordinatorMemberListVersion);
        out.writeInt(this.participants.size());
        for (MemberInfo participant : this.participants) {
            participant.writeData(out);
        }
        Data planBlob = this.getNodeEngine().getSerializationService().toData((Object)this.planSupplier.get());
        out.writeData(planBlob);
    }

    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.jobId = in.readLong();
        this.executionId = in.readLong();
        this.coordinatorMemberListVersion = in.readInt();
        int count = in.readInt();
        this.participants = new HashSet<MemberInfo>();
        for (int i = 0; i < count; ++i) {
            MemberInfo participant = new MemberInfo();
            participant.readData(in);
            this.participants.add(participant);
        }
        Data planBlob = in.readData();
        this.planSupplier = () -> {
            JetService service = (JetService)this.getService();
            ClassLoader cl = service.getClassLoader(this.jobId);
            return (ExecutionPlan)CustomClassLoadedObject.deserializeWithCustomClassLoader(this.getNodeEngine().getSerializationService(), cl, planBlob);
        };
    }
}

