/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.operation.AsyncExecutionOperation;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.concurrent.CompletionStage;

public class ExecuteOperation
extends AsyncExecutionOperation {
    private volatile CompletionStage<Void> executionFuture;
    private long executionId;

    public ExecuteOperation() {
    }

    public ExecuteOperation(long jobId, long executionId) {
        super(jobId);
        this.executionId = executionId;
    }

    @Override
    protected void doRun() throws Exception {
        ILogger logger = this.getLogger();
        JetService service = (JetService)this.getService();
        this.executionFuture = service.execute(this.getCallerAddress(), this.jobId, this.executionId, f -> f.handle((r, error) -> error).thenAccept(value -> {
            if (value != null) {
                logger.fine("Execution of " + Util.jobAndExecutionId(this.jobId, this.executionId) + " completed with failure", value);
            } else {
                logger.fine("Execution of " + Util.jobAndExecutionId(this.jobId, this.executionId) + " completed");
            }
            this.doSendResponse(value);
        }));
    }

    @Override
    public void cancel() {
        if (this.executionFuture != null) {
            this.executionFuture.toCompletableFuture().cancel(true);
        }
    }

    public int getId() {
        return 6;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.executionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.executionId = in.readLong();
    }
}

