/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution.init;

import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.Address;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class PartitionArrangement {
    final Supplier<Map<Address, int[]>> remotePartitionAssignment;
    private final Supplier<int[]> localPartitions = Util.memoize(() -> PartitionArrangement.arrangeLocalPartitions(partitionOwners, thisAddress));
    private final Supplier<int[]> allPartitions = Util.memoize(() -> PartitionArrangement.arrangeAllPartitions(partitionOwners, this.localPartitions.get()));

    PartitionArrangement(Address[] partitionOwners, Address thisAddress) {
        this.remotePartitionAssignment = Util.memoize(() -> PartitionArrangement.remotePartitionAssignment(partitionOwners, thisAddress));
    }

    int[][] assignPartitionsToProcessors(int processorCount, boolean isEdgeDistributed) {
        int[] arrangedPtions = (isEdgeDistributed ? this.localPartitions : this.allPartitions).get();
        int[][] ptionsPerProcessor = PartitionArrangement.createPtionArrays(arrangedPtions.length, processorCount);
        int majorIndex = 0;
        int minorIndex = 0;
        int[] nArray = arrangedPtions;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int ptionId;
            ptionsPerProcessor[majorIndex][minorIndex] = ptionId = nArray[i];
            if (++majorIndex != processorCount) continue;
            majorIndex = 0;
            ++minorIndex;
        }
        return ptionsPerProcessor;
    }

    private static int[] arrangeLocalPartitions(Address[] partitionOwners, Address thisAddress) {
        return IntStream.range(0, partitionOwners.length).filter(partitionId -> thisAddress.equals((Object)partitionOwners[partitionId])).toArray();
    }

    private static int[] arrangeAllPartitions(Address[] partitionOwners, int[] localPartitions) {
        int totalPartitionCount = partitionOwners.length;
        int[] allPartitions = Arrays.copyOf(localPartitions, totalPartitionCount);
        int i = localPartitions.length;
        for (int ption = 0; ption < totalPartitionCount; ++ption) {
            if (Arrays.binarySearch(localPartitions, ption) >= 0) continue;
            allPartitions[i++] = ption;
        }
        return allPartitions;
    }

    private static int[][] createPtionArrays(int ptionCount, int processorCount) {
        int[][] ptionsPerProcessor = new int[processorCount][];
        int quot = ptionCount / processorCount;
        int rem = ptionCount % processorCount;
        Arrays.setAll(ptionsPerProcessor, i -> new int[quot + (i < rem ? 1 : 0)]);
        return ptionsPerProcessor;
    }

    private static Map<Address, int[]> remotePartitionAssignment(Address[] partitionOwners, Address thisAddress) {
        Map<Address, List<Integer>> addrToPartitions = IntStream.range(0, partitionOwners.length).filter(partitionId -> !thisAddress.equals((Object)partitionOwners[partitionId])).boxed().collect(Collectors.groupingBy(partitionId -> partitionOwners[partitionId]));
        return addrToPartitions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().mapToInt(x -> x).toArray()));
    }
}

