/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution;

import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.execution.ReceiverTasklet;
import com.hazelcast.jet.impl.execution.SenderTasklet;
import com.hazelcast.jet.impl.execution.SnapshotContext;
import com.hazelcast.jet.impl.execution.Tasklet;
import com.hazelcast.jet.impl.execution.TaskletExecutionService;
import com.hazelcast.jet.impl.execution.init.ExecutionPlan;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;

public class ExecutionContext {
    private final long jobId;
    private final long executionId;
    private final Address coordinator;
    private final Set<Address> participants;
    private final Object executionLock = new Object();
    private final ILogger logger;
    private Map<Integer, Map<Integer, Map<Address, ReceiverTasklet>>> receiverMap = Collections.emptyMap();
    private Map<Integer, Map<Integer, Map<Address, SenderTasklet>>> senderMap = Collections.emptyMap();
    private List<ProcessorSupplier> procSuppliers = Collections.emptyList();
    private List<Processor> processors = Collections.emptyList();
    private List<Tasklet> tasklets;
    private CompletionStage<Void> jobFuture;
    private final NodeEngine nodeEngine;
    private final TaskletExecutionService execService;
    private SnapshotContext snapshotContext;

    public ExecutionContext(NodeEngine nodeEngine, TaskletExecutionService execService, long jobId, long executionId, Address coordinator, Set<Address> participants) {
        this.jobId = jobId;
        this.executionId = executionId;
        this.coordinator = coordinator;
        this.participants = new HashSet<Address>(participants);
        this.execService = execService;
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(this.getClass());
    }

    public ExecutionContext initialize(ExecutionPlan plan) {
        this.procSuppliers = Collections.unmodifiableList(plan.getProcessorSuppliers());
        this.processors = plan.getProcessors();
        this.snapshotContext = new SnapshotContext(this.nodeEngine.getLogger(SnapshotContext.class), this.jobId, this.executionId, plan.lastSnapshotId(), plan.getJobConfig().getProcessingGuarantee());
        plan.initialize(this.nodeEngine, this.jobId, this.executionId, this.snapshotContext);
        this.snapshotContext.initTaskletCount(plan.getStoreSnapshotTaskletCount(), plan.getHigherPriorityVertexCount());
        this.receiverMap = Collections.unmodifiableMap(plan.getReceiverMap());
        this.senderMap = Collections.unmodifiableMap(plan.getSenderMap());
        this.tasklets = plan.getTasklets();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Void> execute(Consumer<CompletionStage<Void>> doneCallback) {
        Object object = this.executionLock;
        synchronized (object) {
            if (this.jobFuture != null) {
                this.jobFuture.whenComplete(ExceptionUtil.withTryCatch(this.logger, (r, e) -> doneCallback.accept(this.jobFuture)));
            } else {
                JetService service = (JetService)this.nodeEngine.getService("hz:impl:jetService");
                ClassLoader cl = service.getClassLoader(this.jobId);
                this.jobFuture = this.execService.execute(this.tasklets, doneCallback, cl);
                this.jobFuture.whenComplete(ExceptionUtil.withTryCatch(this.logger, (r, e) -> this.tasklets.clear()));
            }
            return this.jobFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Void> cancel() {
        Object object = this.executionLock;
        synchronized (object) {
            if (this.jobFuture == null) {
                this.jobFuture = new CompletableFuture<Void>();
            }
            this.jobFuture.toCompletableFuture().cancel(true);
            return this.jobFuture;
        }
    }

    public long getJobId() {
        return this.jobId;
    }

    public long getExecutionId() {
        return this.executionId;
    }

    public Map<Integer, Map<Integer, Map<Address, SenderTasklet>>> senderMap() {
        return this.senderMap;
    }

    public Map<Integer, Map<Integer, Map<Address, ReceiverTasklet>>> receiverMap() {
        return this.receiverMap;
    }

    public boolean verify(Address coordinator, long jobId) {
        return this.coordinator.equals((Object)coordinator) && this.jobId == jobId;
    }

    public void complete(Throwable error) {
        ILogger logger = this.nodeEngine.getLogger(this.getClass());
        this.procSuppliers.forEach(s -> {
            try {
                s.complete(error);
            }
            catch (Throwable e) {
                logger.severe(Util.jobAndExecutionId(this.jobId, this.executionId) + " encountered an exception in ProcessorSupplier.complete(), ignoring it", e);
            }
        });
        MetricsRegistry metricsRegistry = ((NodeEngineImpl)this.nodeEngine).getMetricsRegistry();
        this.processors.forEach(arg_0 -> ((MetricsRegistry)metricsRegistry).deregister(arg_0));
    }

    public void handlePacket(int vertexId, int ordinal, Address sender, BufferObjectDataInput in) {
        this.receiverMap.get(vertexId).get(ordinal).get(sender).receiveStreamPacket(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Void> beginSnapshot(long snapshotId) {
        Object object = this.executionLock;
        synchronized (object) {
            if (this.jobFuture == null) {
                throw new RetryableHazelcastException();
            }
            if (this.jobFuture.toCompletableFuture().isDone()) {
                throw new CancellationException();
            }
            return this.snapshotContext.startNewSnapshot(snapshotId);
        }
    }

    public boolean isParticipating(Address member) {
        return this.participants.contains(member);
    }

    public Address getCoordinator() {
        return this.coordinator;
    }

    public boolean isCoordinatorOrParticipating(Address member) {
        return this.coordinator.equals((Object)member) || this.isParticipating(member);
    }

    public SnapshotContext getSnapshotContext() {
        return this.snapshotContext;
    }
}

