/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.jet.core.CloseableProcessorSupplier;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Outbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedConsumer;
import com.hazelcast.jet.function.DistributedIntFunction;
import java.io.Closeable;
import javax.annotation.Nonnull;

public final class WriteBufferedP<B, T>
implements Processor,
Closeable {
    private final DistributedIntFunction<B> newBufferFn;
    private final DistributedBiConsumer<B, T> addToBufferFn;
    private final DistributedConsumer<B> flushBufferFn;
    private final DistributedConsumer<B> disposeBufferFn;
    private B buffer;

    WriteBufferedP(DistributedIntFunction<B> newBufferFn, DistributedBiConsumer<B, T> addToBufferFn, DistributedConsumer<B> flushBufferFn, DistributedConsumer<B> disposeBufferFn) {
        this.newBufferFn = newBufferFn;
        this.addToBufferFn = addToBufferFn;
        this.flushBufferFn = flushBufferFn;
        this.disposeBufferFn = disposeBufferFn;
    }

    @Override
    public void init(@Nonnull Outbox outbox, @Nonnull Processor.Context context) {
        this.buffer = this.newBufferFn.apply(context.globalProcessorIndex());
    }

    @Nonnull
    public static <B, T> ProcessorSupplier supplier(DistributedIntFunction<B> newBufferFn, DistributedBiConsumer<B, T> addToBufferFn, DistributedConsumer<B> flushBufferFn, DistributedConsumer<B> disposeBufferFn) {
        return new CloseableProcessorSupplier(() -> new WriteBufferedP(newBufferFn, addToBufferFn, flushBufferFn, disposeBufferFn));
    }

    @Override
    public void process(int ordinal, @Nonnull Inbox inbox) {
        inbox.drain(item -> {
            if (!(item instanceof Watermark)) {
                this.addToBufferFn.accept(this.buffer, item);
            }
        });
        this.flushBufferFn.accept(this.buffer);
    }

    @Override
    public boolean complete() {
        this.close();
        return true;
    }

    @Override
    public void close() {
        this.disposeBufferFn.accept(this.buffer);
    }

    @Override
    public boolean isCooperative() {
        return false;
    }
}

