/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.client;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.MessageTaskFactory;
import com.hazelcast.client.impl.protocol.MessageTaskFactoryProvider;
import com.hazelcast.client.impl.protocol.codec.JetCancelJobCodec;
import com.hazelcast.client.impl.protocol.codec.JetGetJobIdsCodec;
import com.hazelcast.client.impl.protocol.codec.JetGetJobStatusCodec;
import com.hazelcast.client.impl.protocol.codec.JetJoinSubmittedJobCodec;
import com.hazelcast.client.impl.protocol.codec.JetSubmitJobCodec;
import com.hazelcast.client.impl.protocol.task.MessageTask;
import com.hazelcast.instance.Node;
import com.hazelcast.jet.impl.client.GetJobIdsMessageTask;
import com.hazelcast.jet.impl.client.JetCancelJobMessageTask;
import com.hazelcast.jet.impl.client.JetGetJobStatusMessageTask;
import com.hazelcast.jet.impl.client.JetJoinSubmittedJobMessageTask;
import com.hazelcast.jet.impl.client.JetSubmitJobMessageTask;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;

public class JetMessageTaskFactoryProvider
implements MessageTaskFactoryProvider {
    private final MessageTaskFactory[] factories = new MessageTaskFactory[Short.MAX_VALUE];
    private final Node node;

    public JetMessageTaskFactoryProvider(NodeEngine nodeEngine) {
        this.node = ((NodeEngineImpl)nodeEngine).getNode();
        this.initFactories();
    }

    public void initFactories() {
        this.factories[JetSubmitJobCodec.RequestParameters.TYPE.id()] = this.toFactory(JetSubmitJobMessageTask::new);
        this.factories[JetCancelJobCodec.RequestParameters.TYPE.id()] = this.toFactory(JetCancelJobMessageTask::new);
        this.factories[JetGetJobStatusCodec.RequestParameters.TYPE.id()] = this.toFactory(JetGetJobStatusMessageTask::new);
        this.factories[JetGetJobIdsCodec.RequestParameters.TYPE.id()] = this.toFactory(GetJobIdsMessageTask::new);
        this.factories[JetJoinSubmittedJobCodec.RequestParameters.TYPE.id()] = this.toFactory(JetJoinSubmittedJobMessageTask::new);
    }

    public MessageTaskFactory[] getFactories() {
        return (MessageTaskFactory[])this.factories.clone();
    }

    private MessageTaskFactory toFactory(MessageTaskConstructor constructor) {
        return (clientMessage, connection) -> constructor.construct(clientMessage, this.node, connection);
    }

    private static interface MessageTaskConstructor {
        public MessageTask construct(ClientMessage var1, Node var2, Connection var3);
    }
}

