/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.aggregate;

import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.util.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AggregateOperationImpl<A, R>
implements AggregateOperation<A, R> {
    final DistributedBiConsumer<? super A, ?>[] accumulateFs;
    private final DistributedSupplier<A> createAccumulatorFn;
    private final DistributedBiConsumer<? super A, ? super A> combineAccumulatorsFn;
    private final DistributedBiConsumer<? super A, ? super A> deductAccumulatorFn;
    private final DistributedFunction<? super A, R> finishAccumulationFn;

    public AggregateOperationImpl(@Nonnull DistributedSupplier<A> createAccumulatorFn, @Nonnull DistributedBiConsumer<? super A, ?>[] accumulateFs, @Nullable DistributedBiConsumer<? super A, ? super A> combineAccumulatorsFn, @Nullable DistributedBiConsumer<? super A, ? super A> deductAccumulatorFn, @Nonnull DistributedFunction<? super A, R> finishAccumulationFn) {
        for (DistributedBiConsumer<? super A, ?> f : accumulateFs) {
            Preconditions.checkNotNull(f, (String)"accumulateFs array contains a null slot");
        }
        this.createAccumulatorFn = createAccumulatorFn;
        this.accumulateFs = (DistributedBiConsumer[])accumulateFs.clone();
        this.combineAccumulatorsFn = combineAccumulatorsFn;
        this.deductAccumulatorFn = deductAccumulatorFn;
        this.finishAccumulationFn = finishAccumulationFn;
    }

    @Override
    @Nonnull
    public DistributedSupplier<A> createFn() {
        return this.createAccumulatorFn;
    }

    @Override
    @Nonnull
    public <T> DistributedBiConsumer<? super A, ? super T> accumulateFn(int index) {
        if (index >= this.accumulateFs.length) {
            throw new IllegalArgumentException("This AggregateOperation has " + this.accumulateFs.length + " accumulating functions, but was asked for function at index " + index);
        }
        return this.accumulateFs[index];
    }

    @Override
    @Nullable
    public DistributedBiConsumer<? super A, ? super A> combineFn() {
        return this.combineAccumulatorsFn;
    }

    @Override
    @Nullable
    public DistributedBiConsumer<? super A, ? super A> deductFn() {
        return this.deductAccumulatorFn;
    }

    @Override
    @Nonnull
    public DistributedFunction<? super A, R> finishFn() {
        return this.finishAccumulationFn;
    }

    @Override
    public <R1> AggregateOperation<A, R1> withFinishFn(@Nonnull DistributedFunction<? super A, R1> finishFn) {
        return new AggregateOperationImpl<A, R1>(this.createFn(), this.accumulateFs, this.combineFn(), this.deductFn(), finishFn);
    }

    @Nonnull
    static <A> DistributedBiConsumer<? super A, ?>[] accumulateFs(DistributedBiConsumer ... accFs) {
        return accFs;
    }
}

