/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.aggregation.Aggregator;
import com.hazelcast.aggregation.impl.MaxByAggregator;
import com.hazelcast.core.IMap;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.impl.execution.SnapshotRecord;
import com.hazelcast.jet.impl.util.LoggingUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.stream.IStreamMap;
import com.hazelcast.logging.ILogger;
import com.hazelcast.query.Predicate;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;

public class SnapshotRepository {
    public static final String SNAPSHOT_NAME_PREFIX = "__jet.snapshots.";
    public static final String SNAPSHOT_DATA_NAME_PREFIX = "__jet.snapshots.data.";
    private static final long LATEST_STARTED_SNAPSHOT_ID_KEY = -1L;
    private final JetInstance instance;
    private final ILogger logger;

    public SnapshotRepository(JetInstance jetInstance) {
        this.instance = jetInstance;
        this.logger = jetInstance.getHazelcastInstance().getLoggingService().getLogger(this.getClass());
    }

    long registerSnapshot(long jobId, Collection<String> vertexNames) {
        long nextSnapshotId;
        SnapshotRecord record;
        IStreamMap<Long, Object> snapshots = this.getSnapshotMap(jobId);
        while (snapshots.putIfAbsent((record = new SnapshotRecord(jobId, nextSnapshotId = this.generateNextSnapshotId(snapshots), vertexNames)).snapshotId(), record) != null) {
        }
        return record.snapshotId();
    }

    private long generateNextSnapshotId(IStreamMap<Long, Object> snapshots) {
        long nextSnapshotId;
        Long snapshotId;
        do {
            long l = nextSnapshotId = (snapshotId = (Long)snapshots.get(-1L)) == null ? 0L : snapshotId + 1L;
        } while (!SnapshotRepository.replaceAllowingNull(snapshots, -1L, snapshotId, nextSnapshotId));
        return nextSnapshotId;
    }

    private static <K, V> boolean replaceAllowingNull(IMap<K, V> map, K key, V oldValue, V newValue) {
        if (oldValue == null) {
            return map.putIfAbsent(key, newValue) == null;
        }
        return map.replace(key, oldValue, newValue);
    }

    long setSnapshotStatus(long jobId, long snapshotId, SnapshotRecord.SnapshotStatus status) {
        IStreamMap snapshots = this.getSnapshotMap(jobId);
        SnapshotRecord record = (SnapshotRecord)Util.compute(snapshots, snapshotId, (k, r) -> {
            r.setStatus(status);
            return r;
        });
        return System.currentTimeMillis() - record.startTime();
    }

    @Nullable
    Long latestCompleteSnapshot(long jobId) {
        Predicate & Serializable completedSnapshots;
        MaxByAggregator<Map.Entry<Long, Object>> entryMaxByAggregator;
        IStreamMap snapshotMap = this.getSnapshotMap(jobId);
        Map.Entry entry = (Map.Entry)snapshotMap.aggregate((Aggregator)(entryMaxByAggregator = this.maxByAggregator()), completedSnapshots = (Predicate & Serializable)e -> {
            Object value = e.getValue();
            return value instanceof SnapshotRecord && ((SnapshotRecord)value).isSuccessful();
        });
        return entry != null ? (Long)entry.getKey() : null;
    }

    @Nullable
    Long latestStartedSnapshot(long jobId) {
        IStreamMap map = this.getSnapshotMap(jobId);
        return (Long)map.get(-1L);
    }

    public <T> IStreamMap<Long, T> getSnapshotMap(long jobId) {
        return this.instance.getMap(SnapshotRepository.snapshotsMapName(jobId));
    }

    private MaxByAggregator<Map.Entry<Long, Object>> maxByAggregator() {
        return new MaxByAggregator("snapshotId");
    }

    public static String snapshotsMapName(long jobId) {
        return SNAPSHOT_NAME_PREFIX + Util.idToString(jobId);
    }

    public static String snapshotDataMapName(long jobId, long snapshotId, String vertexName) {
        return SNAPSHOT_DATA_NAME_PREFIX + Util.idToString(jobId) + '.' + snapshotId + '.' + vertexName;
    }

    void deleteAllSnapshotsExceptOne(long jobId, Long snapshotToKeep) {
        IStreamMap<Long, SnapshotRecord> snapshotMap = this.getSnapshotMap(jobId);
        Predicate & Serializable predicate = (Predicate & Serializable)e -> !((Long)e.getKey()).equals(-1L) && !((Long)e.getKey()).equals(snapshotToKeep);
        for (Map.Entry entry : snapshotMap.entrySet(predicate)) {
            this.deleteSnapshot(snapshotMap, (SnapshotRecord)entry.getValue());
        }
    }

    void deleteSingleSnapshot(long jobId, Long snapshotId) {
        IStreamMap<Long, SnapshotRecord> snapshotMap = this.getSnapshotMap(jobId);
        SnapshotRecord record = (SnapshotRecord)snapshotMap.get(snapshotId);
        if (record != null) {
            this.deleteSnapshot(snapshotMap, record);
        }
    }

    void deleteAllSnapshots(long jobId) {
        IStreamMap snapshotMap = this.getSnapshotMap(jobId);
        Predicate & Serializable predicate = (Predicate & Serializable)e -> !e.getKey().equals(-1L);
        for (Map.Entry entry : snapshotMap.entrySet(predicate)) {
            this.deleteSnapshotData((SnapshotRecord)entry.getValue());
        }
        LoggingUtil.logFine(this.logger, "Deleted all snapshots for job %s", Util.idToString(jobId));
        snapshotMap.destroy();
    }

    private void deleteSnapshot(IStreamMap<Long, SnapshotRecord> map, SnapshotRecord record) {
        this.setSnapshotStatus(record.jobId(), record.snapshotId(), SnapshotRecord.SnapshotStatus.TO_DELETE);
        this.deleteSnapshotData(record);
        map.remove(record.snapshotId());
        LoggingUtil.logFinest(this.logger, "Deleted snapshot record for snapshot %d for job %s", record.snapshotId(), Util.idToString(record.jobId()));
    }

    private void deleteSnapshotData(SnapshotRecord record) {
        for (String vertexName : record.vertices()) {
            String mapName = SnapshotRepository.snapshotDataMapName(record.jobId(), record.snapshotId(), vertexName);
            this.instance.getMap(mapName).destroy();
            LoggingUtil.logFine(this.logger, "Deleted snapshot data for snapshot %d for job %s and vertex '%s'", record.snapshotId(), Util.idToString(record.jobId()), vertexName);
        }
    }
}

