/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.jet.ComputeStage;
import com.hazelcast.jet.Pipeline;
import com.hazelcast.jet.Sink;
import com.hazelcast.jet.SinkStage;
import com.hazelcast.jet.Source;
import com.hazelcast.jet.Stage;
import com.hazelcast.jet.Transform;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.impl.ComputeStageImpl;
import com.hazelcast.jet.impl.Planner;
import com.hazelcast.jet.impl.SinkStageImpl;
import com.hazelcast.jet.impl.transform.MultiTransform;
import com.hazelcast.jet.impl.transform.UnaryTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class PipelineImpl
implements Pipeline {
    private final Map<Stage, List<Stage>> adjacencyMap = new HashMap<Stage, List<Stage>>();

    @Override
    @Nonnull
    public <E> ComputeStage<E> drawFrom(@Nonnull Source<E> source) {
        return new ComputeStageImpl<E>(source, this);
    }

    @Override
    @Nonnull
    public DAG toDag() {
        return new Planner(this).createDag();
    }

    public ComputeStage attach(List<ComputeStage> upstream, MultiTransform transform) {
        ComputeStageImpl attached = new ComputeStageImpl(upstream, (Transform)transform, this);
        upstream.forEach(u -> this.connect((ComputeStage)u, attached));
        return attached;
    }

    <IN, OUT> ComputeStage<OUT> attach(ComputeStage<IN> upstream, UnaryTransform<? super IN, OUT> unaryTransform) {
        ComputeStageImpl attached = new ComputeStageImpl(upstream, unaryTransform, this);
        this.connect(upstream, attached);
        return attached;
    }

    <E> SinkStage drainTo(ComputeStage<E> upstream, Sink sink) {
        SinkStageImpl output = new SinkStageImpl(upstream, sink, this);
        this.connect(upstream, output);
        return output;
    }

    Map<Stage, List<Stage>> adjacencyMap() {
        HashMap<Stage, List<Stage>> safeCopy = new HashMap<Stage, List<Stage>>();
        this.adjacencyMap.forEach((k, v) -> {
            List cfr_ignored_0 = safeCopy.put((Stage)k, new ArrayList(v));
        });
        return safeCopy;
    }

    void register(Stage stage, List<Stage> downstream) {
        List<Stage> prev = this.adjacencyMap.put(stage, downstream);
        assert (prev == null) : "Double registering of a Stage with this Pipeline: " + stage;
    }

    private void connect(ComputeStage upstream, Stage downstream) {
        this.adjacencyMap.get(upstream).add(downstream);
    }
}

