/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.jet.impl.operation.AsyncExecutionOperation;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.LiveOperations;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class LiveOperationRegistry {
    final ConcurrentHashMap<Address, Map<Long, AsyncExecutionOperation>> liveOperations = new ConcurrentHashMap();

    public void register(AsyncExecutionOperation operation) {
        Map callIds = this.liveOperations.computeIfAbsent(operation.getCallerAddress(), key -> new ConcurrentHashMap());
        if (callIds.putIfAbsent(operation.getCallId(), operation) != null) {
            throw new IllegalStateException("Duplicate operation during registration of operation=" + (Object)((Object)operation));
        }
    }

    public void deregister(AsyncExecutionOperation operation) {
        Map<Long, AsyncExecutionOperation> operations = this.liveOperations.get(operation.getCallerAddress());
        if (operations == null) {
            throw new IllegalStateException("Missing address during de-registration of operation=" + (Object)((Object)operation));
        }
        if (operations.remove(operation.getCallId()) == null) {
            throw new IllegalStateException("Missing operation during de-registration of operation=" + (Object)((Object)operation));
        }
    }

    void populate(LiveOperations liveOperations) {
        this.liveOperations.forEach((key, value) -> value.keySet().forEach(callId -> liveOperations.add(key, callId.longValue())));
    }

    boolean cancel(Address caller, long callId) {
        Optional<AsyncExecutionOperation> operation = Optional.ofNullable(this.liveOperations.get(caller)).map(m -> (AsyncExecutionOperation)((Object)((Object)m.get(callId))));
        operation.ifPresent(AsyncExecutionOperation::cancel);
        return operation.isPresent();
    }
}

