/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.client.impl.ClientEngineImpl;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.JetBuildInfo;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.core.TopologyChangedException;
import com.hazelcast.jet.impl.ClientInvocationRegistry;
import com.hazelcast.jet.impl.JetInstanceImpl;
import com.hazelcast.jet.impl.JobCoordinationService;
import com.hazelcast.jet.impl.JobExecutionService;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.jet.impl.LiveOperationRegistry;
import com.hazelcast.jet.impl.Networking;
import com.hazelcast.jet.impl.SnapshotRepository;
import com.hazelcast.jet.impl.execution.TaskletExecutionService;
import com.hazelcast.jet.impl.execution.init.ExecutionPlan;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.CanCancelOperations;
import com.hazelcast.spi.ConfigurableService;
import com.hazelcast.spi.LiveOperations;
import com.hazelcast.spi.LiveOperationsTracker;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MemberAttributeServiceEvent;
import com.hazelcast.spi.MembershipAwareService;
import com.hazelcast.spi.MembershipServiceEvent;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.PacketHandler;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class JetService
implements ManagedService,
ConfigurableService<JetConfig>,
PacketHandler,
LiveOperationsTracker,
CanCancelOperations,
MembershipAwareService {
    public static final String SERVICE_NAME = "hz:impl:jetService";
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private final ClientInvocationRegistry clientInvocationRegistry;
    private final LiveOperationRegistry liveOperationRegistry;
    private JetConfig config;
    private JetInstance jetInstance;
    private Networking networking;
    private TaskletExecutionService taskletExecutionService;
    private JobRepository jobRepository;
    private SnapshotRepository snapshotRepository;
    private JobCoordinationService jobCoordinationService;
    private JobExecutionService jobExecutionService;
    private final AtomicInteger numConcurrentPutAllOps = new AtomicInteger();

    public JetService(NodeEngine nodeEngine) {
        this.nodeEngine = (NodeEngineImpl)nodeEngine;
        this.logger = nodeEngine.getLogger(this.getClass());
        this.clientInvocationRegistry = new ClientInvocationRegistry();
        this.liveOperationRegistry = new LiveOperationRegistry();
    }

    public void configure(JetConfig config) {
        this.config = config;
    }

    public void init(NodeEngine engine, Properties properties) {
        if (this.config == null) {
            throw new IllegalStateException("JetConfig is not initialized");
        }
        this.jetInstance = new JetInstanceImpl((HazelcastInstanceImpl)engine.getHazelcastInstance(), this.config);
        this.taskletExecutionService = new TaskletExecutionService(this.nodeEngine.getHazelcastInstance(), this.config.getInstanceConfig().getCooperativeThreadCount());
        this.snapshotRepository = new SnapshotRepository(this.jetInstance);
        this.jobRepository = new JobRepository(this.jetInstance, this.snapshotRepository);
        this.jobExecutionService = new JobExecutionService(this.nodeEngine, this.taskletExecutionService);
        this.jobCoordinationService = new JobCoordinationService(this.nodeEngine, this.config, this.jobRepository, this.jobExecutionService, this.snapshotRepository);
        this.networking = new Networking(engine, this.jobExecutionService, this.config.getInstanceConfig().getFlowControlPeriodMs());
        ClientEngineImpl clientEngine = (ClientEngineImpl)engine.getService("hz:core:clientEngine");
        ExceptionUtil.registerJetExceptions(clientEngine.getClientExceptionFactory());
        this.jobCoordinationService.init();
        JetBuildInfo jetBuildInfo = BuildInfoProvider.getBuildInfo().getJetBuildInfo();
        this.logger.info(String.format("Starting Jet %s (%s - %s)", jetBuildInfo.getVersion(), jetBuildInfo.getBuild(), jetBuildInfo.getRevision()));
        this.logger.info("Setting number of cooperative threads and default parallelism to " + this.config.getInstanceConfig().getCooperativeThreadCount());
        this.logger.info("\n\to   o   o   o---o o---o o     o---o   o   o---o o-o-o        o o---o o-o-o\n\t|   |  / \\     /  |     |     |      / \\  |       |          | |       |  \n\to---o o---o   o   o-o   |     o     o---o o---o   |          | o-o     |  \n\t|   | |   |  /    |     |     |     |   |     |   |      \\   | |       |  \n\to   o o   o o---o o---o o---o o---o o   o o---o   o       o--o o---o   o   ");
        this.logger.info("Copyright (c) 2008-2017, Hazelcast, Inc. All Rights Reserved.");
    }

    public void shutdown(boolean terminate) {
        this.jobExecutionService.reset("shutdown", HazelcastInstanceNotActiveException::new);
        this.networking.shutdown();
        this.taskletExecutionService.shutdown();
    }

    public void reset() {
        this.jobCoordinationService.reset();
        this.jobExecutionService.reset("reset", TopologyChangedException::new);
    }

    public void initExecution(long jobId, long executionId, Address coordinator, int coordinatorMemberListVersion, Set<MemberInfo> participants, ExecutionPlan plan) {
        this.jobExecutionService.initExecution(jobId, executionId, coordinator, coordinatorMemberListVersion, participants, plan);
    }

    public CompletionStage<Void> execute(Address coordinator, long jobId, long executionId, Consumer<CompletionStage<Void>> doneCallback) {
        return this.jobExecutionService.execute(coordinator, jobId, executionId, doneCallback);
    }

    public void completeExecution(long executionId, Throwable error) {
        this.jobExecutionService.completeExecution(executionId, error);
    }

    public JobStatus getJobStatus(long jobId) {
        return this.jobCoordinationService.getJobStatus(jobId);
    }

    public JetInstance getJetInstance() {
        return this.jetInstance;
    }

    public LiveOperationRegistry getLiveOperationRegistry() {
        return this.liveOperationRegistry;
    }

    public ClientInvocationRegistry getClientInvocationRegistry() {
        return this.clientInvocationRegistry;
    }

    public JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public JobCoordinationService getJobCoordinationService() {
        return this.jobCoordinationService;
    }

    public JobExecutionService getJobExecutionService() {
        return this.jobExecutionService;
    }

    public ClassLoader getClassLoader(long jobId) {
        return this.jobCoordinationService.getClassLoader(jobId);
    }

    public void populate(LiveOperations liveOperations) {
        this.liveOperationRegistry.populate(liveOperations);
    }

    public boolean cancelOperation(Address caller, long callId) {
        return this.liveOperationRegistry.cancel(caller, callId);
    }

    public void handle(Packet packet) throws IOException {
        this.networking.handle(packet);
    }

    public void memberRemoved(MembershipServiceEvent event) {
        Address address = event.getMember().getAddress();
        this.jobExecutionService.onMemberLeave(address);
    }

    public void memberAdded(MembershipServiceEvent event) {
        this.jobCoordinationService.updateQuorumValues();
    }

    public void memberAttributeChanged(MemberAttributeServiceEvent event) {
    }

    public CompletableFuture<Boolean> submitJob(long jobId, Data dag, JobConfig config) {
        return this.jobCoordinationService.submitOrJoinJob(jobId, dag, config);
    }

    public CompletableFuture<Boolean> joinSubmittedJob(long jobId) {
        return this.jobCoordinationService.joinSubmittedJob(jobId);
    }

    public Set<Long> getAllJobIds() {
        return this.jobCoordinationService.getAllJobIds();
    }

    public AtomicInteger numConcurrentPutAllOps() {
        return this.numConcurrentPutAllOps;
    }
}

