/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.spi.impl.SimpleExecutionCallback;
import java.util.concurrent.ConcurrentHashMap;

public class ClientInvocationRegistry {
    private final ConcurrentHashMap<Long, ICompletableFuture<Object>> clientInvocations = new ConcurrentHashMap();

    public void register(final long executionId, ICompletableFuture<Object> invocation) {
        if (this.clientInvocations.putIfAbsent(executionId, invocation) != null) {
            throw new IllegalStateException("Execution with id " + Util.idToString(executionId) + " is already registered.");
        }
        invocation.andThen((ExecutionCallback)new SimpleExecutionCallback<Object>(){

            public void notify(Object o) {
                ClientInvocationRegistry.this.clientInvocations.remove(executionId);
            }
        });
    }

    public void cancel(long executionId) {
        ICompletableFuture<Object> f = this.clientInvocations.get(executionId);
        if (f != null) {
            f.cancel(true);
        }
    }
}

