/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.impl.JetCacheManagerImpl;
import com.hazelcast.jet.stream.IStreamList;
import com.hazelcast.jet.stream.IStreamMap;
import com.hazelcast.jet.stream.JetCacheManager;
import com.hazelcast.jet.stream.impl.ListDecorator;
import com.hazelcast.jet.stream.impl.MapDecorator;

abstract class AbstractJetInstance
implements JetInstance {
    private final HazelcastInstance hazelcastInstance;
    private final JetCacheManagerImpl cacheManager;

    AbstractJetInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
        this.cacheManager = new JetCacheManagerImpl(this);
    }

    @Override
    public Cluster getCluster() {
        return this.getHazelcastInstance().getCluster();
    }

    @Override
    public String getName() {
        return this.hazelcastInstance.getName();
    }

    @Override
    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    @Override
    public <K, V> IStreamMap<K, V> getMap(String name) {
        return new MapDecorator(this.hazelcastInstance.getMap(name), this);
    }

    @Override
    public <E> IStreamList<E> getList(String name) {
        return new ListDecorator(this.hazelcastInstance.getList(name), this);
    }

    @Override
    public JetCacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public void shutdown() {
        this.hazelcastInstance.shutdown();
    }
}

